/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.gherkin;

import com.trivago.vo.DataTable;
import com.trivago.vo.Step;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Singleton;

@Singleton
class GherkinToCucableConverter {
    GherkinToCucableConverter() {
    }

    public List<Step> convertGherkinStepsToCucableSteps(List<io.cucumber.messages.types.Step> gherkinSteps) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (io.cucumber.messages.types.Step gherkinStep : gherkinSteps) {
            DataTable dataTable = gherkinStep.getDataTable().map(this::convertGherkinDataTableToCucableDataTable).orElse(null);
            String docString = gherkinStep.getDocString().map(DocString::getContent).orElse(null);
            String keywordAndName = gherkinStep.getKeyword().concat(gherkinStep.getText());
            Step step = new Step(keywordAndName, dataTable, docString);
            steps.add(step);
        }
        return steps;
    }

    public DataTable convertGherkinDataTableToCucableDataTable(io.cucumber.messages.types.DataTable gherkinDataTable) {
        DataTable dataTable = new DataTable();
        gherkinDataTable.getRows().stream().map(TableRow::getCells).map(cells -> cells.stream().map(TableCell::getValue).collect(Collectors.toList())).forEachOrdered(dataTable::addRow);
        return dataTable;
    }

    List<String> convertGherkinTagsToCucableTags(List<Tag> gherkinTags) {
        return gherkinTags.stream().map(Tag::getName).collect(Collectors.toList());
    }

    public Map<String, List<String>> convertGherkinExampleTableToCucableExampleMap(Examples exampleTable) {
        List headerCells = ((TableRow)exampleTable.getTableHeader().orElseThrow(() -> new IllegalArgumentException("Examples table must have a header"))).getCells();
        Map exampleMap = headerCells.stream().collect(Collectors.toMap(headerCell -> "<" + headerCell.getValue() + ">", headerCell -> new ArrayList(), (a, b) -> b, LinkedHashMap::new));
        Object[] columnKeys = exampleMap.keySet().toArray();
        List tableBody = exampleTable.getTableBody();
        tableBody.stream().map(TableRow::getCells).forEachOrdered(cells -> IntStream.range(0, cells.size()).forEachOrdered(i -> {
            String columnKey = (String)columnKeys[i];
            List values = (List)exampleMap.get(columnKey);
            values.add(((TableCell)cells.get(i)).getValue());
        }));
        return exampleMap;
    }

    public DataTable convertPickleTableToCucableDataTable(PickleTable pickleTable) {
        DataTable dataTable = new DataTable();
        pickleTable.getRows().forEach(row -> {
            List<String> values = row.getCells().stream().map(PickleTableCell::getValue).collect(Collectors.toList());
            dataTable.addRow(values);
        });
        return dataTable;
    }
}

