/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.logging;

import java.util.Arrays;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CucableLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucableLogger.class);
    private CucableLogLevel currentLogLevel;

    public void initialize(String currentLogLevel) {
        if (currentLogLevel == null) {
            this.currentLogLevel = CucableLogLevel.DEFAULT;
            return;
        }
        try {
            this.currentLogLevel = CucableLogLevel.valueOf(currentLogLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.currentLogLevel = CucableLogLevel.DEFAULT;
            this.warn("Log level " + currentLogLevel + " is unknown. Cucable will use 'default' logging.");
        }
    }

    public void logInfoSeparator(CucableLogLevel ... cucableLogLevels) {
        this.info("--------------------------------------", cucableLogLevels);
    }

    public void info(String logString, CucableLogLevel ... cucableLogLevels) {
        this.log(LogLevel.INFO, logString, cucableLogLevels);
    }

    public void warn(String logString) {
        CucableLogLevel[] logLevels = new CucableLogLevel[]{CucableLogLevel.DEFAULT, CucableLogLevel.COMPACT, CucableLogLevel.MINIMAL};
        this.log(LogLevel.WARN, logString, logLevels);
    }

    private void log(LogLevel logLevel, String logString, CucableLogLevel ... cucableLogLevels) {
        if (this.currentLogLevel != null && cucableLogLevels != null && cucableLogLevels.length > 0 && Arrays.stream(cucableLogLevels).noneMatch(cucableLogLevel -> cucableLogLevel == this.currentLogLevel)) {
            return;
        }
        switch (logLevel) {
            case INFO: {
                LOGGER.info(logString);
                break;
            }
            case WARN: {
                LOGGER.warn(logString);
            }
        }
    }

    public static enum CucableLogLevel {
        DEFAULT,
        COMPACT,
        MINIMAL,
        OFF;

    }

    private static enum LogLevel {
        INFO,
        WARN;

    }
}

