/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.properties;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.properties.WrongOrMissingPropertiesException;
import com.trivago.files.FileSystemManager;
import com.trivago.logging.CucableLogger;
import com.trivago.vo.CucableFeature;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private final CucableLogger logger;
    private final FileSystemManager fileSystemManager;
    private String sourceRunnerTemplateFile;
    private String generatedRunnerDirectory;
    private List<CucableFeature> sourceFeatures;
    private String generatedFeatureDirectory;
    private int numberOfTestRuns;
    private String includeScenarioTags;
    private ParallelizationMode parallelizationMode;
    private Map<String, String> customPlaceholders;
    private int desiredNumberOfRunners = -1;
    private int desiredNumberOfFeaturesPerRunner;
    private List<String> scenarioNames = new ArrayList<String>();

    @Inject
    public PropertyManager(CucableLogger logger, FileSystemManager fileSystemManager) {
        this.logger = logger;
        this.fileSystemManager = fileSystemManager;
    }

    public String getSourceRunnerTemplateFile() {
        return this.sourceRunnerTemplateFile;
    }

    public void setSourceRunnerTemplateFile(String sourceRunnerTemplateFile) {
        this.sourceRunnerTemplateFile = sourceRunnerTemplateFile;
    }

    public String getGeneratedRunnerDirectory() {
        return this.generatedRunnerDirectory;
    }

    public void setGeneratedRunnerDirectory(String generatedRunnerDirectory) {
        if (generatedRunnerDirectory == null) {
            return;
        }
        this.generatedRunnerDirectory = generatedRunnerDirectory.replaceAll("/$", "");
    }

    public List<CucableFeature> getSourceFeatures() {
        return this.sourceFeatures;
    }

    public void setSourceFeatures(String sourceFeatures) throws CucablePluginException {
        ArrayList<String> allFeaturePaths = new ArrayList<String>();
        ArrayList<String> allFeaturePathOrigins = new ArrayList<String>();
        ArrayList<String> allTextFileOrigins = new ArrayList<String>();
        for (String currentSourceFeature : sourceFeatures.split(",")) {
            String currentSourceFeatureOrigin = currentSourceFeature = currentSourceFeature.trim();
            if (currentSourceFeature.startsWith("@")) {
                String cleanedUpPath = currentSourceFeature.substring(1);
                ArrayList<String> textFiles = new ArrayList<String>();
                if (!cleanedUpPath.endsWith(".txt")) {
                    List<Path> filesWithTxtExtension = this.fileSystemManager.getFilesWithExtension(cleanedUpPath, "txt");
                    for (Path path : filesWithTxtExtension) {
                        textFiles.add(path.toString());
                    }
                } else {
                    textFiles.add(cleanedUpPath);
                }
                for (String textFile : textFiles) {
                    String[] singleInsideFeatures;
                    String insideFeatures = this.fileSystemManager.readContentFromFile(textFile);
                    for (String singleInsideFeature : singleInsideFeatures = insideFeatures.split("\n")) {
                        allFeaturePathOrigins.add(currentSourceFeatureOrigin);
                        allFeaturePaths.add(singleInsideFeature);
                        allTextFileOrigins.add(textFile);
                    }
                }
                continue;
            }
            allFeaturePathOrigins.add(currentSourceFeatureOrigin);
            allFeaturePaths.add(currentSourceFeature);
            allTextFileOrigins.add("");
        }
        this.sourceFeatures = this.sourceFeaturePathsToCucableFeatureList(allFeaturePaths, allTextFileOrigins, allFeaturePathOrigins);
    }

    private List<CucableFeature> sourceFeaturePathsToCucableFeatureList(List<String> sourceFeatures, List<String> textFileOrigins, List<String> sourceFeatureOrigins) {
        ArrayList<CucableFeature> cucableFeatures = new ArrayList<CucableFeature>();
        Pattern lineNumberPattern = Pattern.compile(":(\\d*)");
        for (int i = 0; i < sourceFeatures.size(); ++i) {
            String sourceFeature = sourceFeatures.get(i);
            String trimmedFeature = sourceFeature.trim();
            StringBuffer resultBuffer = new StringBuffer();
            Matcher matcher = lineNumberPattern.matcher(trimmedFeature);
            ArrayList<Integer> scenarioLineNumbers = new ArrayList<Integer>();
            while (matcher.find()) {
                try {
                    scenarioLineNumbers.add(Integer.parseInt(matcher.group(1)));
                    matcher.appendReplacement(resultBuffer, "");
                }
                catch (NumberFormatException numberFormatException) {}
            }
            matcher.appendTail(resultBuffer);
            CucableFeature cucableFeature = new CucableFeature(sourceFeatureOrigins.get(i), textFileOrigins.get(i), resultBuffer.toString(), scenarioLineNumbers);
            cucableFeatures.add(cucableFeature);
        }
        return cucableFeatures;
    }

    public String getGeneratedFeatureDirectory() {
        return this.generatedFeatureDirectory;
    }

    public void setGeneratedFeatureDirectory(String generatedFeatureDirectory) {
        this.generatedFeatureDirectory = generatedFeatureDirectory.replaceAll("/$", "");
    }

    public int getNumberOfTestRuns() {
        return this.numberOfTestRuns;
    }

    public void setNumberOfTestRuns(int numberOfTestRuns) {
        this.numberOfTestRuns = numberOfTestRuns;
    }

    public String getIncludeScenarioTags() {
        return this.includeScenarioTags;
    }

    public void setIncludeScenarioTags(String includeScenarioTags) {
        this.includeScenarioTags = includeScenarioTags;
    }

    public ParallelizationMode getParallelizationMode() {
        return this.parallelizationMode;
    }

    public void setParallelizationMode(String parallelizationMode) throws CucablePluginException {
        try {
            this.parallelizationMode = ParallelizationMode.valueOf(parallelizationMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new CucablePluginException("Unknown <parallelizationMode> '" + parallelizationMode + "'. Please use 'scenarios' or 'features'.");
        }
    }

    public Map<String, String> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    public void setCustomPlaceholders(Map<String, String> customPlaceholders) {
        this.customPlaceholders = customPlaceholders;
    }

    public int getDesiredNumberOfRunners() {
        return this.desiredNumberOfRunners;
    }

    public void setDesiredNumberOfRunners(int desiredNumberOfRunners) {
        this.desiredNumberOfRunners = desiredNumberOfRunners;
    }

    public int getDesiredNumberOfFeaturesPerRunner() {
        return this.desiredNumberOfFeaturesPerRunner;
    }

    public void setDesiredNumberOfFeaturesPerRunner(int desiredNumberOfFeaturesPerRunner) {
        this.desiredNumberOfFeaturesPerRunner = desiredNumberOfFeaturesPerRunner;
    }

    public List<String> getScenarioNames() {
        return this.scenarioNames;
    }

    public void setScenarioNames(String scenarioNames) {
        List<String> scenarioNameList = new ArrayList<String>();
        if (scenarioNames != null && !scenarioNames.trim().isEmpty()) {
            scenarioNameList = Arrays.asList(scenarioNames.trim().split("\\s*,\\s*"));
            this.setDesiredNumberOfRunners(scenarioNameList.size());
        }
        this.scenarioNames = scenarioNameList;
    }

    public void checkForMissingMandatoryProperties() throws CucablePluginException {
        ArrayList<String> missingProperties = new ArrayList<String>();
        if (this.sourceFeatures == null || this.sourceFeatures.isEmpty()) {
            missingProperties.add("<sourceFeatures>");
        }
        if (this.desiredNumberOfRunners != 0) {
            if (this.sourceRunnerTemplateFile == null || this.sourceRunnerTemplateFile.isEmpty()) {
                this.saveMissingProperty(this.sourceRunnerTemplateFile, "<sourceRunnerTemplateFile>", missingProperties);
            }
            if (this.generatedRunnerDirectory == null || this.generatedRunnerDirectory.isEmpty()) {
                this.saveMissingProperty(this.generatedRunnerDirectory, "<generatedRunnerDirectory>", missingProperties);
            }
        }
        this.saveMissingProperty(this.generatedFeatureDirectory, "<generatedFeatureDirectory>", missingProperties);
        if (!missingProperties.isEmpty()) {
            throw new WrongOrMissingPropertiesException(missingProperties);
        }
    }

    public void checkForDisallowedPropertyCombinations() throws CucablePluginException {
        if (this.desiredNumberOfFeaturesPerRunner > 0 && this.desiredNumberOfRunners > 0) {
            throw new CucablePluginException("You cannot use desiredNumberOfFeaturesPerRunner and desiredNumberOfRunners/scenarioNames at the same time!");
        }
        if (this.parallelizationMode == ParallelizationMode.SCENARIOS) {
            return;
        }
        String errorMessage = "";
        if (!new File(String.valueOf(this.sourceFeatures.get(0).getName())).isDirectory()) {
            errorMessage = "sourceFeatures should point to a directory!";
        } else if (this.includeScenarioTags != null && !this.includeScenarioTags.isEmpty()) {
            errorMessage = "you cannot specify includeScenarioTags!";
        } else if (this.scenarioNames != null && !this.scenarioNames.isEmpty()) {
            errorMessage = "you cannot specify scenarioNames!";
        }
        if (!errorMessage.isEmpty()) {
            throw new CucablePluginException("In parallelizationMode = " + ParallelizationMode.FEATURES.toString().toLowerCase() + ", ".concat(errorMessage));
        }
    }

    public void logProperties() {
        CucableLogger.CucableLogLevel[] logLevels = new CucableLogger.CucableLogLevel[]{CucableLogger.CucableLogLevel.DEFAULT, CucableLogger.CucableLogLevel.COMPACT};
        if (this.sourceFeatures != null) {
            this.logger.info("- sourceFeatures:", logLevels);
            String currentOrigin = null;
            for (CucableFeature sourceFeature : this.sourceFeatures) {
                if (Objects.equals(currentOrigin, sourceFeature.getOrigin())) continue;
                currentOrigin = sourceFeature.getOrigin();
                String logLine = "  - " + currentOrigin;
                this.logger.info(logLine, logLevels);
            }
        } else {
            this.logger.info("- sourceFeatures               : not specified", logLevels);
        }
        if (this.desiredNumberOfRunners != 0) {
            this.logger.info(String.format("- sourceRunnerTemplateFile     : %s", this.sourceRunnerTemplateFile), logLevels);
        }
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        this.logger.info(String.format("- generatedFeatureDirectory    : %s", this.generatedFeatureDirectory), logLevels);
        if (this.desiredNumberOfRunners != 0) {
            this.logger.info(String.format("- generatedRunnerDirectory     : %s", this.generatedRunnerDirectory), logLevels);
        }
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        if (this.includeScenarioTags != null && !this.includeScenarioTags.isEmpty()) {
            this.logger.info(String.format("- includeScenarioTags          : %s", String.join((CharSequence)", ", this.includeScenarioTags)), logLevels);
        }
        if (this.customPlaceholders != null && !this.customPlaceholders.isEmpty()) {
            this.logger.info("- customPlaceholders           :", logLevels);
            for (Map.Entry<String, String> customPlaceholder : this.customPlaceholders.entrySet()) {
                this.logger.info(String.format("  %s => %s", customPlaceholder.getKey(), customPlaceholder.getValue()), logLevels);
            }
        }
        this.logger.info(String.format("- parallelizationMode          : %s", this.parallelizationMode.name().toLowerCase()), logLevels);
        this.logger.info(String.format("- numberOfTestRuns             : %d", this.numberOfTestRuns), logLevels);
        if (this.desiredNumberOfRunners > 0) {
            this.logger.info(String.format("- desiredNumberOfRunners       : %d", this.desiredNumberOfRunners), logLevels);
        }
        this.logger.logInfoSeparator(logLevels);
    }

    private void saveMissingProperty(String propertyValue, String propertyName, List<String> missingProperties) {
        if (propertyValue == null || propertyValue.isEmpty()) {
            missingProperties.add(propertyName);
        }
    }

    public static enum ParallelizationMode {
        SCENARIOS,
        FEATURES;

    }
}

