/*
 * Decompiled with CFR 0.152.
 */
package com.trivago;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.features.FeatureFileConverter;
import com.trivago.files.FileSystemManager;
import com.trivago.logging.CucableLogger;
import com.trivago.properties.PropertyManager;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="parallel")
final class CucablePlugin
extends AbstractMojo {
    private final PropertyManager propertyManager;
    private final FileSystemManager fileManager;
    private final FeatureFileConverter featureFileConverter;
    private final CucableLogger logger;
    @Parameter(property="parallel.sourceRunnerTemplateFile", required=true)
    private String sourceRunnerTemplateFile;
    @Parameter(property="parallel.generatedRunnerDirectory", required=true)
    private String generatedRunnerDirectory;
    @Parameter(property="parallel.sourceFeatures", required=true)
    private String sourceFeatures;
    @Parameter(property="parallel.generatedFeatureDirectory", required=true)
    private String generatedFeatureDirectory;
    @Parameter(property="parallel.numberOfTestRuns", defaultValue="1")
    private int numberOfTestRuns;
    @Parameter(property="parallel.includeScenarioTags")
    private String includeScenarioTags;
    @Parameter(property="parallel.parallelizationMode", defaultValue="scenarios")
    private String parallelizationMode;
    @Parameter(property="parallel.desiredNumberOfRunners", defaultValue="0")
    private int desiredNumberOfRunners;
    @Parameter(property="parallel.desiredNumberOfFeaturesPerRunner", defaultValue="0")
    private int desiredNumberOfFeaturesPerRunner;
    @Parameter(property="parallel.logLevel", defaultValue="default")
    private String logLevel;
    @Parameter(property="parallel.customPlaceholders")
    private Map<String, String> customPlaceholders;
    @Parameter(property="parallel.scenarioNames")
    private String scenarioNames;

    @Inject
    public CucablePlugin(PropertyManager propertyManager, FileSystemManager fileManager, FeatureFileConverter featureFileConverter, CucableLogger logger) {
        this.propertyManager = propertyManager;
        this.fileManager = fileManager;
        this.featureFileConverter = featureFileConverter;
        this.logger = logger;
    }

    public void execute() throws CucablePluginException {
        this.logger.initialize(this.getLog(), this.logLevel);
        this.propertyManager.setSourceRunnerTemplateFile(this.sourceRunnerTemplateFile);
        this.propertyManager.setGeneratedRunnerDirectory(this.generatedRunnerDirectory);
        this.propertyManager.setSourceFeatures(this.sourceFeatures);
        this.propertyManager.setGeneratedFeatureDirectory(this.generatedFeatureDirectory);
        this.propertyManager.setNumberOfTestRuns(this.numberOfTestRuns);
        this.propertyManager.setIncludeScenarioTags(this.includeScenarioTags);
        this.propertyManager.setParallelizationMode(this.parallelizationMode);
        this.propertyManager.setCustomPlaceholders(this.customPlaceholders);
        this.propertyManager.setDesiredNumberOfRunners(this.desiredNumberOfRunners);
        this.propertyManager.setDesiredNumberOfFeaturesPerRunner(this.desiredNumberOfFeaturesPerRunner);
        this.propertyManager.setScenarioNames(this.scenarioNames);
        this.propertyManager.checkForMissingMandatoryProperties();
        this.propertyManager.checkForDisallowedPropertyCombinations();
        this.logPluginInformationHeader();
        this.propertyManager.logProperties();
        this.fileManager.prepareGeneratedFeatureAndRunnerDirectories();
        this.featureFileConverter.generateParallelizableFeatures(this.propertyManager.getSourceFeatures());
    }

    private void logPluginInformationHeader() {
        CucableLogger.CucableLogLevel[] cucableLogLevels = new CucableLogger.CucableLogLevel[]{CucableLogger.CucableLogLevel.DEFAULT, CucableLogger.CucableLogLevel.COMPACT};
        this.logger.logInfoSeparator(cucableLogLevels);
        this.logger.info(String.format(" Cucable Maven Plugin, version %s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion()), cucableLogLevels);
        this.logger.logInfoSeparator(cucableLogLevels);
    }
}

