/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.features;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FileCreationException;
import com.trivago.exceptions.filesystem.MissingFileException;
import com.trivago.features.FeatureFileContentRenderer;
import com.trivago.files.FileIO;
import com.trivago.files.FileSystemManager;
import com.trivago.gherkin.GherkinDocumentParser;
import com.trivago.logging.CucableLogger;
import com.trivago.logging.Language;
import com.trivago.properties.PropertyManager;
import com.trivago.runners.RunnerFileContentRenderer;
import com.trivago.vo.CucableFeature;
import com.trivago.vo.FeatureRunner;
import com.trivago.vo.SingleScenario;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ast.GherkinDocument;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FeatureFileConverter {
    private static final String FEATURE_FILE_EXTENSION = ".feature";
    private static final String RUNNER_FILE_EXTENSION = ".java";
    private static final String INTEGRATION_TEST_POSTFIX = "_IT";
    private static final String PATH_SEPARATOR = "/";
    private static final String TEST_RUNS_COUNTER_FORMAT = "_run%03d";
    private static final String TEST_RERUNS_FORMAT = "_rerun";
    private static final String FEATURE_COUNTER_FORMAT = "_feature%03d";
    private static final String SCENARIO_COUNTER_FORMAT = "_scenario%03d";
    private final PropertyManager propertyManager;
    private final GherkinDocumentParser gherkinDocumentParser;
    private final FeatureFileContentRenderer featureFileContentRenderer;
    private final RunnerFileContentRenderer runnerFileContentRenderer;
    private final FileIO fileIO;
    private final FileSystemManager fileSystemManager;
    private final CucableLogger logger;
    private final Map<String, Integer> singleFeatureCounters = new HashMap<String, Integer>();

    @Inject
    public FeatureFileConverter(PropertyManager propertyManager, GherkinDocumentParser gherkinDocumentParser, FeatureFileContentRenderer featureFileContentRenderer, RunnerFileContentRenderer runnerFileContentRenderer, FileIO fileIO, FileSystemManager fileSystemManager, CucableLogger logger) {
        this.propertyManager = propertyManager;
        this.gherkinDocumentParser = gherkinDocumentParser;
        this.featureFileContentRenderer = featureFileContentRenderer;
        this.runnerFileContentRenderer = runnerFileContentRenderer;
        this.fileIO = fileIO;
        this.fileSystemManager = fileSystemManager;
        this.logger = logger;
    }

    public void generateParallelizableFeatures(List<CucableFeature> cucableFeatures) throws CucablePluginException {
        int featureFileCounter = 0;
        ArrayList<String> allGeneratedFeaturePaths = new ArrayList<String>();
        for (CucableFeature cucableFeature : cucableFeatures) {
            List<Path> paths = this.fileSystemManager.getPathsFromCucableFeature(cucableFeature);
            if (paths.size() == 0) {
                this.logger.warn("No features and runners could be created. Please check your properties!");
            }
            for (Path path : paths) {
                List<String> generatedFeatureFilePaths = this.generateParallelizableFeatures(path, cucableFeature.getLineNumbers());
                allGeneratedFeaturePaths.addAll(generatedFeatureFilePaths);
                featureFileCounter += generatedFeatureFilePaths.size();
            }
        }
        int runnerFileCounter = this.propertyManager.getDesiredNumberOfFeaturesPerRunner() > 0 ? this.generateRunnerClassesWithDesiredNumberOfFeatures(allGeneratedFeaturePaths, this.propertyManager.getDesiredNumberOfFeaturesPerRunner()) : this.generateRunnerClassesWithDesiredNumberOfRunners(allGeneratedFeaturePaths, this.propertyManager.getDesiredNumberOfRunners());
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        this.logger.info(String.format("Cucable created %d separate %s and %d %s.", featureFileCounter, Language.singularPlural(featureFileCounter, "feature file", "feature files"), runnerFileCounter, Language.singularPlural(runnerFileCounter, "runner", "runners")), CucableLogger.CucableLogLevel.DEFAULT, CucableLogger.CucableLogLevel.COMPACT, CucableLogger.CucableLogLevel.MINIMAL);
    }

    private List<String> generateParallelizableFeatures(Path sourceFeatureFilePath, List<Integer> lineNumbers) throws CucablePluginException {
        if (this.propertyManager.getParallelizationMode() == PropertyManager.ParallelizationMode.FEATURES) {
            return this.generateFeaturesWithFeaturesParallelizationMode(sourceFeatureFilePath);
        }
        return this.generateFeaturesWithScenariosParallelizationMode(sourceFeatureFilePath, lineNumbers);
    }

    private List<String> generateFeaturesWithFeaturesParallelizationMode(Path sourceFeatureFilePath) throws CucablePluginException {
        String featureFilePathString = sourceFeatureFilePath.toString();
        String featureFileContent = this.fileIO.readContentFromFile(featureFilePathString);
        return this.generateFeatureFiles(sourceFeatureFilePath, featureFileContent);
    }

    private List<String> generateFeaturesWithScenariosParallelizationMode(Path sourceFeatureFilePath, List<Integer> lineNumbers) throws CucablePluginException {
        String featureFilePathString = sourceFeatureFilePath.toString();
        if (featureFilePathString == null || featureFilePathString.equals("")) {
            throw new MissingFileException(featureFilePathString);
        }
        String featureFileContent = this.fileIO.readContentFromFile(featureFilePathString);
        List<SingleScenario> singleScenarios = this.gherkinDocumentParser.getSingleScenariosFromFeature(featureFileContent, featureFilePathString, lineNumbers);
        return this.generateFeatureFiles(sourceFeatureFilePath, singleScenarios);
    }

    private List<String> generateFeatureFiles(Path sourceFeatureFilePath, List<SingleScenario> singleScenarios) throws FileCreationException {
        ArrayList<String> generatedFeaturePaths = new ArrayList<String>();
        for (SingleScenario singleScenario : singleScenarios) {
            Integer featureCounter;
            String featureFileName = this.getFeatureFileNameFromPath(sourceFeatureFilePath);
            Integer n = featureCounter = this.singleFeatureCounters.getOrDefault(featureFileName, 0);
            featureCounter = featureCounter + 1;
            String scenarioCounterFilenamePart = String.format(SCENARIO_COUNTER_FORMAT, featureCounter);
            for (int testRuns = 1; testRuns <= this.propertyManager.getNumberOfTestRuns(); ++testRuns) {
                String generatedFileName = featureFileName.concat(scenarioCounterFilenamePart);
                String testRunsCounterFilenamePart = String.format(TEST_RUNS_COUNTER_FORMAT, testRuns);
                generatedFileName = generatedFileName.concat(testRunsCounterFilenamePart);
                if (this.propertyManager.isCucumberFeatureListFileSource()) {
                    generatedFileName = generatedFileName.concat(TEST_RERUNS_FORMAT);
                }
                generatedFileName = generatedFileName.concat(INTEGRATION_TEST_POSTFIX);
                this.saveFeature(generatedFileName, this.featureFileContentRenderer.getRenderedFeatureFileContent(singleScenario));
                generatedFeaturePaths.add(generatedFileName);
                this.singleFeatureCounters.put(featureFileName, featureCounter);
            }
        }
        this.logFeatureFileConversionMessage(sourceFeatureFilePath.toString(), singleScenarios.size());
        return generatedFeaturePaths;
    }

    private List<String> generateFeatureFiles(Path sourceFeatureFilePath, String featureFileContent) throws FileCreationException {
        Integer featureCounter;
        ArrayList<String> generatedFeaturePaths = new ArrayList<String>();
        String featureFileName = this.getFeatureFileNameFromPath(sourceFeatureFilePath);
        Integer n = featureCounter = this.singleFeatureCounters.getOrDefault(featureFileName, 0);
        featureCounter = featureCounter + 1;
        String featureCounterFilenamePart = String.format(FEATURE_COUNTER_FORMAT, featureCounter);
        for (int testRuns = 1; testRuns <= this.propertyManager.getNumberOfTestRuns(); ++testRuns) {
            String testRunsCounterFilenamePart = String.format(TEST_RUNS_COUNTER_FORMAT, testRuns);
            String generatedFileName = featureFileName.concat(featureCounterFilenamePart).concat(testRunsCounterFilenamePart).concat(INTEGRATION_TEST_POSTFIX);
            this.saveFeature(generatedFileName, featureFileContent);
            generatedFeaturePaths.add(generatedFileName);
            this.singleFeatureCounters.put(featureFileName, featureCounter);
        }
        this.logger.info(String.format("- processed %s.", featureFileName), CucableLogger.CucableLogLevel.DEFAULT);
        return generatedFeaturePaths;
    }

    private void saveFeature(String featureFileName, String renderedFeatureFileContent) throws FileCreationException {
        String generatedFeatureFilePath = this.propertyManager.getGeneratedFeatureDirectory().concat(PATH_SEPARATOR).concat(featureFileName).concat(FEATURE_FILE_EXTENSION);
        this.fileIO.writeContentToFile(renderedFeatureFileContent, generatedFeatureFilePath);
    }

    private int generateRunnerClassesWithDesiredNumberOfRunners(List<String> generatedFeatureNames, int numberOfDesiredRunners) throws CucablePluginException {
        int targetRunnerNumber = numberOfDesiredRunners;
        List<String> scenarioNames = this.propertyManager.getScenarioNames();
        if (targetRunnerNumber == 0) {
            targetRunnerNumber = generatedFeatureNames.size();
        }
        ArrayList generatedFeatureNamesPerRunner = new ArrayList(targetRunnerNumber);
        for (int i = 0; i < targetRunnerNumber; ++i) {
            generatedFeatureNamesPerRunner.add(new ArrayList());
        }
        int currentRunnerIndex = 0;
        int matchCount = 0;
        for (String generatedFeatureName : generatedFeatureNames) {
            Parser parser;
            String language;
            int listIndex;
            if (scenarioNames.isEmpty()) {
                ((List)generatedFeatureNamesPerRunner.get(currentRunnerIndex)).add(generatedFeatureName);
                if (++currentRunnerIndex < targetRunnerNumber) continue;
                currentRunnerIndex = 0;
                continue;
            }
            String string = this.fileIO.readContentFromFile(this.propertyManager.getGeneratedFeatureDirectory() + PATH_SEPARATOR + generatedFeatureName + FEATURE_FILE_EXTENSION);
            if (string == null || (listIndex = this.gherkinDocumentParser.matchScenarioWithScenarioNames(language = ((GherkinDocument)(parser = new Parser((Parser.Builder)new AstBuilder())).parse(string)).getFeature().getLanguage(), string)) < 0) continue;
            ((List)generatedFeatureNamesPerRunner.get(listIndex)).add(generatedFeatureName);
            ++matchCount;
        }
        if (!scenarioNames.isEmpty() && matchCount == 0) {
            throw new CucablePluginException("No matching scenarios found for specified scenario names - " + Arrays.toString(scenarioNames.toArray()) + "!");
        }
        int runnerFileCounter = 0;
        for (List list : generatedFeatureNamesPerRunner) {
            if (list.size() <= 0) continue;
            this.generateRunnerClass(list);
            ++runnerFileCounter;
        }
        return runnerFileCounter;
    }

    private int generateRunnerClassesWithDesiredNumberOfFeatures(List<String> generatedFeatureNames, int numberOfDesiredFeaturesPerRunner) throws CucablePluginException {
        int currentRunnerFeatureCount = 0;
        int totalFeatureCount = 0;
        ArrayList<String> generatedFeatureNamesForSingleRunner = new ArrayList<String>();
        int runnerFileCounter = 0;
        for (String generatedFeatureName : generatedFeatureNames) {
            generatedFeatureNamesForSingleRunner.add(generatedFeatureName);
            if (++totalFeatureCount != generatedFeatureNames.size() && ++currentRunnerFeatureCount < numberOfDesiredFeaturesPerRunner) continue;
            ++runnerFileCounter;
            this.generateRunnerClass(generatedFeatureNamesForSingleRunner);
            currentRunnerFeatureCount = 0;
            generatedFeatureNamesForSingleRunner = new ArrayList();
        }
        return runnerFileCounter;
    }

    private void generateRunnerClass(List<String> generatedFeatureFileNames) throws CucablePluginException {
        String runnerClassName = generatedFeatureFileNames.size() == 1 ? "Runner_" + generatedFeatureFileNames.get(0) : "CucableMultiRunner_".concat(UUID.randomUUID().toString().replace("-", "_")).concat(INTEGRATION_TEST_POSTFIX);
        FeatureRunner featureRunner = new FeatureRunner(this.propertyManager.getSourceRunnerTemplateFile(), runnerClassName, generatedFeatureFileNames);
        String renderedRunnerClassContent = this.runnerFileContentRenderer.getRenderedRunnerFileContent(featureRunner);
        String generatedRunnerClassFilePath = this.propertyManager.getGeneratedRunnerDirectory().concat(PATH_SEPARATOR).concat(runnerClassName).concat(RUNNER_FILE_EXTENSION);
        this.fileIO.writeContentToFile(renderedRunnerClassContent, generatedRunnerClassFilePath);
    }

    private void logFeatureFileConversionMessage(String featureFileName, int createdScenarios) {
        String logPostfix = ".";
        this.logger.info(String.format("- generated %3d %s %s%s", createdScenarios, Language.singularPlural(createdScenarios, " scenario from", "scenarios from"), featureFileName, logPostfix), CucableLogger.CucableLogLevel.DEFAULT);
    }

    private String getFeatureFileNameFromPath(Path featureFilePath) {
        String fullFeatureFileName = featureFilePath.getFileName().toString();
        String featureFileName = fullFeatureFileName.substring(0, fullFeatureFileName.lastIndexOf("."));
        return featureFileName.replaceAll("\\W", "_");
    }
}

