/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.files;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FileDeletionException;
import com.trivago.exceptions.filesystem.PathCreationException;
import com.trivago.properties.PropertyManager;
import com.trivago.vo.CucableFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileSystemManager {
    private static final String FEATURE_FILE_EXTENSION = ".feature";
    private final PropertyManager propertyManager;

    @Inject
    public FileSystemManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public List<Path> getPathsFromCucableFeature(CucableFeature cucableFeature) throws CucablePluginException {
        if (cucableFeature == null) {
            return Collections.emptyList();
        }
        String sourceFeatures = cucableFeature.getName().replace("file://", "");
        File sourceFeaturesFile = new File(sourceFeatures);
        if (sourceFeatures.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (sourceFeaturesFile.isFile() && sourceFeatures.endsWith(FEATURE_FILE_EXTENSION)) {
            return Collections.singletonList(Paths.get(sourceFeatures, new String[0]));
        }
        if (sourceFeaturesFile.isDirectory()) {
            return this.getFilesWithFeatureExtension(sourceFeatures);
        }
        throw new CucablePluginException(sourceFeatures + " is not a feature file or a directory.");
    }

    private List<Path> getFilesWithFeatureExtension(String sourceFeatureDirectory) throws CucablePluginException {
        try {
            return Files.walk(Paths.get(sourceFeatureDirectory, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(FEATURE_FILE_EXTENSION)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CucablePluginException("Unable to traverse feature files in " + sourceFeatureDirectory + ": " + e.getMessage());
        }
    }

    public void prepareGeneratedFeatureAndRunnerDirectories() throws CucablePluginException {
        this.createDirIfNotExists(this.propertyManager.getGeneratedFeatureDirectory());
        this.removeFilesFromPath(this.propertyManager.getGeneratedFeatureDirectory(), "feature");
        this.createDirIfNotExists(this.propertyManager.getGeneratedRunnerDirectory());
        this.removeFilesFromPath(this.propertyManager.getGeneratedRunnerDirectory(), "java");
    }

    private void createDirIfNotExists(String dirName) throws PathCreationException {
        File directory = new File(dirName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PathCreationException(dirName);
        }
    }

    private void removeFilesFromPath(String path, String fileExtension) throws FileDeletionException {
        File basePath = new File(path);
        File[] files = basePath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("." + fileExtension) || file.delete()) continue;
                throw new FileDeletionException(file.getName());
            }
        }
    }
}

