/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.gherkin;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FeatureFileParseException;
import com.trivago.gherkin.GherkinToCucableConverter;
import com.trivago.gherkin.GherkinTranslations;
import com.trivago.logging.CucableLogger;
import com.trivago.properties.PropertyManager;
import com.trivago.vo.DataTable;
import com.trivago.vo.SingleScenario;
import com.trivago.vo.Step;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionException;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GherkinDocumentParser {
    private static final Pattern SCENARIO_OUTLINE_PLACEHOLDER_PATTERN = Pattern.compile("<.+?>");
    private final GherkinToCucableConverter gherkinToCucableConverter;
    private final GherkinTranslations gherkinTranslations;
    private final PropertyManager propertyManager;
    private final CucableLogger cucableLogger;

    @Inject
    GherkinDocumentParser(GherkinToCucableConverter gherkinToCucableConverter, GherkinTranslations gherkinTranslations, PropertyManager propertyManager, CucableLogger logger) {
        this.gherkinToCucableConverter = gherkinToCucableConverter;
        this.gherkinTranslations = gherkinTranslations;
        this.propertyManager = propertyManager;
        this.cucableLogger = logger;
    }

    public List<SingleScenario> getSingleScenariosFromFeature(String featureContent, String featureFilePath, List<Integer> scenarioLineNumbers) throws CucablePluginException {
        GherkinDocument gherkinDocument;
        String escapedFeatureContent = featureContent.replace("\\n", "\\\\n");
        try {
            gherkinDocument = this.getGherkinDocumentFromFeatureFileContent(escapedFeatureContent);
        }
        catch (CucablePluginException e) {
            throw new FeatureFileParseException(featureFilePath, e.getMessage());
        }
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return Collections.emptyList();
        }
        String featureName = feature.getKeyword() + ": " + feature.getName();
        String featureLanguage = feature.getLanguage();
        String featureDescription = feature.getDescription();
        List<String> featureTags = this.gherkinToCucableConverter.convertGherkinTagsToCucableTags(feature.getTags());
        ArrayList<SingleScenario> singleScenarioFeatures = new ArrayList<SingleScenario>();
        ArrayList<Step> backgroundSteps = new ArrayList();
        List scenarioDefinitions = feature.getChildren();
        for (ScenarioDefinition scenarioDefinition : scenarioDefinitions) {
            String scenarioName = scenarioDefinition.getKeyword() + ": " + scenarioDefinition.getName();
            String scenarioDescription = scenarioDefinition.getDescription();
            if (scenarioDefinition instanceof Background) {
                Background background = (Background)scenarioDefinition;
                backgroundSteps = this.gherkinToCucableConverter.convertGherkinStepsToCucableSteps(background.getSteps());
                continue;
            }
            if (scenarioDefinition instanceof Scenario) {
                Scenario scenario = (Scenario)scenarioDefinition;
                if (scenarioLineNumbers != null && !scenarioLineNumbers.isEmpty() && !scenarioLineNumbers.contains(scenario.getLocation().getLine())) continue;
                SingleScenario singleScenario = new SingleScenario(featureName, featureFilePath, featureLanguage, featureDescription, scenarioName, scenarioDescription, featureTags, backgroundSteps);
                this.addGherkinScenarioInformationToSingleScenario(scenario, singleScenario);
                if (!this.scenarioShouldBeIncluded(singleScenario)) continue;
                singleScenarioFeatures.add(singleScenario);
                continue;
            }
            if (!(scenarioDefinition instanceof ScenarioOutline)) continue;
            ScenarioOutline scenarioOutline = (ScenarioOutline)scenarioDefinition;
            if (scenarioLineNumbers != null && !scenarioLineNumbers.isEmpty() && !scenarioLineNumbers.contains(scenarioOutline.getLocation().getLine())) continue;
            List<SingleScenario> outlineScenarios = this.getSingleScenariosFromOutline(scenarioOutline, featureName, featureFilePath, featureLanguage, featureDescription, featureTags, backgroundSteps);
            for (SingleScenario singleScenario : outlineScenarios) {
                if (!this.scenarioShouldBeIncluded(singleScenario)) continue;
                singleScenarioFeatures.add(singleScenario);
            }
        }
        return singleScenarioFeatures;
    }

    private List<SingleScenario> getSingleScenariosFromOutline(ScenarioOutline scenarioOutline, String featureName, String featureFilePath, String featureLanguage, String featureDescription, List<String> featureTags, List<Step> backgroundSteps) {
        String translatedScenarioKeyword = this.gherkinTranslations.getScenarioKeyword(featureLanguage);
        String scenarioName = translatedScenarioKeyword + ": " + scenarioOutline.getName();
        String scenarioDescription = scenarioOutline.getDescription();
        List<String> scenarioTags = this.gherkinToCucableConverter.convertGherkinTagsToCucableTags(scenarioOutline.getTags());
        ArrayList<SingleScenario> outlineScenarios = new ArrayList<SingleScenario>();
        List<Step> steps = this.gherkinToCucableConverter.convertGherkinStepsToCucableSteps(scenarioOutline.getSteps());
        if (scenarioOutline.getExamples().isEmpty()) {
            this.cucableLogger.warn("Scenario outline '" + scenarioOutline.getName() + "' without example table!");
            return outlineScenarios;
        }
        for (Examples exampleTable : scenarioOutline.getExamples()) {
            Map<String, List<String>> exampleMap = this.gherkinToCucableConverter.convertGherkinExampleTableToCucableExampleMap(exampleTable);
            String firstColumnHeader = (String)exampleMap.keySet().toArray()[0];
            int rowCount = exampleMap.get(firstColumnHeader).size();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                SingleScenario singleScenario = new SingleScenario(featureName, featureFilePath, featureLanguage, featureDescription, this.replacePlaceholderInString(scenarioName, exampleMap, rowIndex), scenarioDescription, featureTags, backgroundSteps);
                List<Step> substitutedSteps = this.substituteStepExamplePlaceholders(steps, exampleMap, rowIndex);
                singleScenario.setSteps(substitutedSteps);
                singleScenario.setScenarioTags(scenarioTags);
                singleScenario.setExampleTags(this.gherkinToCucableConverter.convertGherkinTagsToCucableTags(exampleTable.getTags()));
                outlineScenarios.add(singleScenario);
            }
        }
        return outlineScenarios;
    }

    private List<Step> substituteStepExamplePlaceholders(List<Step> steps, Map<String, List<String>> exampleMap, int rowIndex) {
        ArrayList<Step> substitutedSteps = new ArrayList<Step>();
        for (Step step : steps) {
            String stepName = step.getName();
            DataTable dataTable = step.getDataTable();
            String substitutedStepName = this.replacePlaceholderInString(stepName, exampleMap, rowIndex);
            DataTable substitutedDataTable = this.replaceDataTableExamplePlaceholder(dataTable, exampleMap, rowIndex);
            substitutedSteps.add(new Step(substitutedStepName, substitutedDataTable, step.getDocString()));
        }
        return substitutedSteps;
    }

    private DataTable replaceDataTableExamplePlaceholder(DataTable dataTable, Map<String, List<String>> exampleMap, int rowIndex) {
        if (dataTable == null) {
            return null;
        }
        List<List<String>> dataTableRows = dataTable.getRows();
        DataTable replacedDataTable = new DataTable();
        for (List<String> dataTableRow : dataTableRows) {
            ArrayList<String> replacedDataTableRow = new ArrayList<String>();
            for (String dataTableCell : dataTableRow) {
                replacedDataTableRow.add(this.replacePlaceholderInString(dataTableCell, exampleMap, rowIndex));
            }
            replacedDataTable.addRow(replacedDataTableRow);
        }
        return replacedDataTable;
    }

    private void addGherkinScenarioInformationToSingleScenario(Scenario gherkinScenario, SingleScenario singleScenario) {
        List<String> tags = this.gherkinToCucableConverter.convertGherkinTagsToCucableTags(gherkinScenario.getTags());
        singleScenario.setScenarioTags(tags);
        List<Step> steps = this.gherkinToCucableConverter.convertGherkinStepsToCucableSteps(gherkinScenario.getSteps());
        singleScenario.setSteps(steps);
    }

    private GherkinDocument getGherkinDocumentFromFeatureFileContent(String featureContent) throws CucablePluginException {
        GherkinDocument gherkinDocument;
        Parser gherkinDocumentParser = new Parser((Parser.Builder)new AstBuilder());
        try {
            gherkinDocument = (GherkinDocument)gherkinDocumentParser.parse(featureContent);
        }
        catch (ParserException parserException) {
            throw new CucablePluginException(parserException.getMessage());
        }
        if (gherkinDocument == null || gherkinDocument.getFeature() == null) {
            this.cucableLogger.warn("No parsable gherkin.");
        }
        return gherkinDocument;
    }

    private boolean scenarioShouldBeIncluded(SingleScenario singleScenario) throws CucablePluginException {
        String scenarioName;
        String includeScenarioTags = this.propertyManager.getIncludeScenarioTags();
        String language = singleScenario.getFeatureLanguage();
        boolean scenarioNameMatchExists = this.matchScenarioWithScenarioNames(language, scenarioName = singleScenario.getScenarioName()) >= 0;
        List<String> combinedScenarioTags = new ArrayList<String>(singleScenario.getScenarioTags());
        combinedScenarioTags.addAll(singleScenario.getFeatureTags());
        combinedScenarioTags.addAll(singleScenario.getExampleTags());
        combinedScenarioTags = combinedScenarioTags.stream().distinct().collect(Collectors.toList());
        if (includeScenarioTags == null || includeScenarioTags.isEmpty()) {
            return scenarioNameMatchExists;
        }
        try {
            Expression tagExpression = TagExpressionParser.parse((String)includeScenarioTags);
            return tagExpression.evaluate(combinedScenarioTags) && scenarioNameMatchExists;
        }
        catch (TagExpressionException e) {
            throw new CucablePluginException("The tag expression '" + includeScenarioTags + "' is invalid: " + e.getMessage());
        }
    }

    public int matchScenarioWithScenarioNames(String language, String stringToMatch) {
        List<String> scenarioNames = this.propertyManager.getScenarioNames();
        String scenarioKeyword = this.gherkinTranslations.getScenarioKeyword(language);
        int matchIndex = -1;
        if (scenarioNames == null || scenarioNames.isEmpty()) {
            return 0;
        }
        for (String scenarioName : scenarioNames) {
            String regex = scenarioKeyword + ":.+" + scenarioName;
            Pattern pattern = Pattern.compile(regex, 8);
            Matcher matcher = pattern.matcher(stringToMatch);
            if (!matcher.find()) continue;
            matchIndex = scenarioNames.indexOf(scenarioName);
            break;
        }
        return matchIndex;
    }

    private String replacePlaceholderInString(String sourceString, Map<String, List<String>> exampleMap, int rowIndex) {
        String result = sourceString;
        Matcher m = SCENARIO_OUTLINE_PLACEHOLDER_PATTERN.matcher(sourceString);
        while (m.find()) {
            String currentPlaceholder = m.group(0);
            List<String> placeholderColumn = exampleMap.get(currentPlaceholder);
            if (placeholderColumn == null) continue;
            result = result.replace(currentPlaceholder, placeholderColumn.get(rowIndex));
        }
        return result;
    }
}

