/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.gherkin;

import com.trivago.vo.DataTable;
import com.trivago.vo.Step;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Node;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Singleton;

@Singleton
class GherkinToCucableConverter {
    GherkinToCucableConverter() {
    }

    List<Step> convertGherkinStepsToCucableSteps(List<gherkin.ast.Step> gherkinSteps) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (gherkin.ast.Step gherkinStep : gherkinSteps) {
            DataTable dataTable = null;
            String docString = null;
            Node argument = gherkinStep.getArgument();
            if (argument instanceof gherkin.ast.DataTable) {
                dataTable = this.convertGherkinDataTableToCucableDataTable((gherkin.ast.DataTable)argument);
            } else if (argument instanceof DocString) {
                docString = ((DocString)argument).getContent();
            }
            String keywordAndName = gherkinStep.getKeyword().concat(gherkinStep.getText());
            Step step = new Step(keywordAndName, dataTable, docString);
            steps.add(step);
        }
        return steps;
    }

    private DataTable convertGherkinDataTableToCucableDataTable(gherkin.ast.DataTable gherkinDataTable) {
        DataTable dataTable = new DataTable();
        gherkinDataTable.getRows().stream().map(TableRow::getCells).map(cells -> cells.stream().map(TableCell::getValue).collect(Collectors.toList())).forEachOrdered(dataTable::addRow);
        return dataTable;
    }

    List<String> convertGherkinTagsToCucableTags(List<Tag> gherkinTags) {
        return gherkinTags.stream().map(Tag::getName).collect(Collectors.toList());
    }

    Map<String, List<String>> convertGherkinExampleTableToCucableExampleMap(Examples exampleTable) {
        List headerCells = exampleTable.getTableHeader().getCells();
        Map exampleMap = headerCells.stream().collect(Collectors.toMap(headerCell -> "<" + headerCell.getValue() + ">", headerCell -> new ArrayList(), (a, b) -> b, LinkedHashMap::new));
        Object[] columnKeys = exampleMap.keySet().toArray();
        List tableBody = exampleTable.getTableBody();
        tableBody.stream().map(TableRow::getCells).forEachOrdered(cells -> IntStream.range(0, cells.size()).forEachOrdered(i -> {
            String columnKey = (String)columnKeys[i];
            List values = (List)exampleMap.get(columnKey);
            values.add(((TableCell)cells.get(i)).getValue());
        }));
        return exampleMap;
    }
}

