/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.properties;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.MissingFileException;
import com.trivago.exceptions.properties.WrongOrMissingPropertiesException;
import com.trivago.files.FileIO;
import com.trivago.logging.CucableLogger;
import com.trivago.logging.Language;
import com.trivago.vo.CucableFeature;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private final CucableLogger logger;
    private final FileIO fileIO;
    private String sourceRunnerTemplateFile;
    private String generatedRunnerDirectory;
    private List<CucableFeature> sourceFeatures;
    private String generatedFeatureDirectory;
    private int numberOfTestRuns;
    private String includeScenarioTags;
    private ParallelizationMode parallelizationMode;
    private Map<String, String> customPlaceholders;
    private int desiredNumberOfRunners;
    private int desiredNumberOfFeaturesPerRunner;
    private List<String> scenarioNames = new ArrayList<String>();
    private String cucumberFeatureListFile;

    @Inject
    public PropertyManager(CucableLogger logger, FileIO fileIO) {
        this.logger = logger;
        this.fileIO = fileIO;
    }

    public String getSourceRunnerTemplateFile() {
        return this.sourceRunnerTemplateFile;
    }

    public void setSourceRunnerTemplateFile(String sourceRunnerTemplateFile) {
        this.sourceRunnerTemplateFile = sourceRunnerTemplateFile;
    }

    public String getGeneratedRunnerDirectory() {
        return this.generatedRunnerDirectory;
    }

    public void setGeneratedRunnerDirectory(String generatedRunnerDirectory) {
        this.generatedRunnerDirectory = generatedRunnerDirectory;
    }

    public List<CucableFeature> getSourceFeatures() {
        return this.sourceFeatures;
    }

    public void setSourceFeatures(String sourceFeatures) throws MissingFileException {
        String featuresToProcess;
        if (sourceFeatures.startsWith("@")) {
            this.cucumberFeatureListFile = sourceFeatures.substring(1);
            featuresToProcess = this.fileIO.readContentFromFile(this.cucumberFeatureListFile).replace(System.lineSeparator(), ",");
        } else {
            featuresToProcess = sourceFeatures;
        }
        this.sourceFeatures = this.sourceFeaturePathsToCucableFeatureList(featuresToProcess.split(","));
    }

    private List<CucableFeature> sourceFeaturePathsToCucableFeatureList(String[] sourceFeatures) {
        ArrayList<CucableFeature> cucableFeatures = new ArrayList<CucableFeature>();
        Pattern lineNumberPattern = Pattern.compile(":(\\d*)");
        for (String sourceFeature : sourceFeatures) {
            String trimmedFeature = sourceFeature.trim();
            StringBuffer resultBuffer = new StringBuffer();
            Matcher matcher = lineNumberPattern.matcher(trimmedFeature);
            ArrayList<Integer> scenarioLineNumbers = new ArrayList<Integer>();
            while (matcher.find()) {
                try {
                    scenarioLineNumbers.add(Integer.parseInt(matcher.group(1)));
                    matcher.appendReplacement(resultBuffer, "");
                }
                catch (NumberFormatException numberFormatException) {}
            }
            matcher.appendTail(resultBuffer);
            cucableFeatures.add(new CucableFeature(resultBuffer.toString(), scenarioLineNumbers));
        }
        return cucableFeatures;
    }

    public String getGeneratedFeatureDirectory() {
        return this.generatedFeatureDirectory;
    }

    public void setGeneratedFeatureDirectory(String generatedFeatureDirectory) {
        this.generatedFeatureDirectory = generatedFeatureDirectory;
    }

    public int getNumberOfTestRuns() {
        return this.numberOfTestRuns;
    }

    public void setNumberOfTestRuns(int numberOfTestRuns) {
        this.numberOfTestRuns = numberOfTestRuns;
    }

    public String getIncludeScenarioTags() {
        return this.includeScenarioTags;
    }

    public void setIncludeScenarioTags(String includeScenarioTags) {
        this.includeScenarioTags = includeScenarioTags;
    }

    public ParallelizationMode getParallelizationMode() {
        return this.parallelizationMode;
    }

    public void setParallelizationMode(String parallelizationMode) throws CucablePluginException {
        try {
            this.parallelizationMode = ParallelizationMode.valueOf(parallelizationMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new CucablePluginException("Unknown <parallelizationMode> '" + parallelizationMode + "'. Please use 'scenarios' or 'features'.");
        }
    }

    public Map<String, String> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    public void setCustomPlaceholders(Map<String, String> customPlaceholders) {
        this.customPlaceholders = customPlaceholders;
    }

    public int getDesiredNumberOfRunners() {
        return this.desiredNumberOfRunners;
    }

    public void setDesiredNumberOfRunners(int desiredNumberOfRunners) {
        this.desiredNumberOfRunners = desiredNumberOfRunners;
    }

    public int getDesiredNumberOfFeaturesPerRunner() {
        return this.desiredNumberOfFeaturesPerRunner;
    }

    public void setDesiredNumberOfFeaturesPerRunner(int desiredNumberOfFeaturesPerRunner) {
        this.desiredNumberOfFeaturesPerRunner = desiredNumberOfFeaturesPerRunner;
    }

    public List<String> getScenarioNames() {
        return this.scenarioNames;
    }

    public void setScenarioNames(String scenarioNames) {
        List<String> scenarioNameList = new ArrayList<String>();
        if (scenarioNames != null && !scenarioNames.trim().isEmpty()) {
            scenarioNameList = Arrays.asList(scenarioNames.trim().split("\\s*,\\s*"));
            this.setDesiredNumberOfRunners(scenarioNameList.size());
        }
        this.scenarioNames = scenarioNameList;
    }

    public void checkForMissingMandatoryProperties() throws CucablePluginException {
        ArrayList<String> missingProperties = new ArrayList<String>();
        if (this.sourceFeatures == null || this.sourceFeatures.isEmpty()) {
            this.saveMissingProperty("", "<sourceFeatures>", missingProperties);
        }
        this.saveMissingProperty(this.sourceRunnerTemplateFile, "<sourceRunnerTemplateFile>", missingProperties);
        this.saveMissingProperty(this.generatedRunnerDirectory, "<generatedRunnerDirectory>", missingProperties);
        this.saveMissingProperty(this.generatedFeatureDirectory, "<generatedFeatureDirectory>", missingProperties);
        if (!missingProperties.isEmpty()) {
            throw new WrongOrMissingPropertiesException(missingProperties);
        }
    }

    public void checkForDisallowedPropertyCombinations() throws CucablePluginException {
        if (this.desiredNumberOfFeaturesPerRunner > 0 && this.desiredNumberOfRunners > 0) {
            throw new CucablePluginException("You cannot use desiredNumberOfFeaturesPerRunner and desiredNumberOfRunners/scenarioNames at the same time!");
        }
        if (this.parallelizationMode == ParallelizationMode.SCENARIOS) {
            return;
        }
        String errorMessage = "";
        if (!new File(String.valueOf(this.sourceFeatures.get(0).getName())).isDirectory()) {
            errorMessage = "sourceFeatures should point to a directory!";
        } else if (this.includeScenarioTags != null && !this.includeScenarioTags.isEmpty()) {
            errorMessage = "you cannot specify includeScenarioTags!";
        } else if (this.scenarioNames != null && !this.scenarioNames.isEmpty()) {
            errorMessage = "you cannot specify scenarioNames!";
        }
        if (!errorMessage.isEmpty()) {
            throw new CucablePluginException("In parallelizationMode = " + ParallelizationMode.FEATURES.toString().toLowerCase() + ", ".concat(errorMessage));
        }
    }

    public void logProperties() {
        CucableLogger.CucableLogLevel[] logLevels = new CucableLogger.CucableLogLevel[]{CucableLogger.CucableLogLevel.DEFAULT, CucableLogger.CucableLogLevel.COMPACT};
        if (!this.isCucumberFeatureListFileSource()) {
            this.logger.info("- sourceFeatures:", logLevels);
        } else {
            this.logger.info(String.format("- sourceFeatures from file %s:", this.cucumberFeatureListFile), logLevels);
        }
        if (this.sourceFeatures != null) {
            for (CucableFeature cucableFeature : this.sourceFeatures) {
                String logLine = "  - " + cucableFeature.getName();
                if (cucableFeature.hasValidScenarioLineNumbers()) {
                    List<Integer> lineNumbers = cucableFeature.getLineNumbers();
                    logLine = logLine + String.format(" (%s %s)", Language.singularPlural(lineNumbers.size(), "line", "lines"), lineNumbers.stream().map(String::valueOf).collect(Collectors.joining(",")));
                }
                this.logger.info(logLine, logLevels);
            }
        }
        this.logger.info(String.format("- sourceRunnerTemplateFile     : %s", this.sourceRunnerTemplateFile), logLevels);
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        this.logger.info(String.format("- generatedRunnerDirectory     : %s", this.generatedRunnerDirectory), logLevels);
        this.logger.info(String.format("- generatedFeatureDirectory    : %s", this.generatedFeatureDirectory), logLevels);
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        if (this.includeScenarioTags != null && !this.includeScenarioTags.isEmpty()) {
            this.logger.info(String.format("- includeScenarioTags          : %s", String.join((CharSequence)", ", this.includeScenarioTags)), logLevels);
        }
        if (this.customPlaceholders != null && !this.customPlaceholders.isEmpty()) {
            this.logger.info("- customPlaceholders           :", logLevels);
            for (Map.Entry entry : this.customPlaceholders.entrySet()) {
                this.logger.info(String.format("  %s => %s", entry.getKey(), entry.getValue()), logLevels);
            }
        }
        this.logger.info(String.format("- parallelizationMode          : %s", this.parallelizationMode.name().toLowerCase()), logLevels);
        this.logger.info(String.format("- numberOfTestRuns             : %d", this.numberOfTestRuns), logLevels);
        if (this.desiredNumberOfRunners > 0) {
            this.logger.info(String.format("- desiredNumberOfRunners       : %d", this.desiredNumberOfRunners), logLevels);
        }
        this.logger.logInfoSeparator(logLevels);
    }

    private void saveMissingProperty(String propertyValue, String propertyName, List<String> missingProperties) {
        if (propertyValue == null || propertyValue.isEmpty()) {
            missingProperties.add(propertyName);
        }
    }

    public boolean isCucumberFeatureListFileSource() {
        return this.cucumberFeatureListFile != null && !this.cucumberFeatureListFile.isEmpty();
    }

    public static enum ParallelizationMode {
        SCENARIOS,
        FEATURES;

    }
}

