/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.runners;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.files.FileIO;
import com.trivago.logging.CucableLogger;
import com.trivago.properties.PropertyManager;
import com.trivago.vo.FeatureRunner;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RunnerFileContentRenderer {
    private static final String FEATURE_FILE_NAME_PLACEHOLDER = "[FEATURE_FILE_NAME]";
    private static final String CUCABLE_FEATURE_PLACEHOLDER = "[CUCABLE:FEATURE]";
    private static final String CUCABLE_RUNNER_PLACEHOLDER = "[CUCABLE:RUNNER]";
    private static final String CUCABLE_CUSTOM_PLACEHOLDER = "[CUCABLE:CUSTOM:%s]";
    private final FileIO fileIO;
    private final PropertyManager propertyManager;
    private final CucableLogger logger;

    @Inject
    public RunnerFileContentRenderer(FileIO fileIO, PropertyManager propertyManager, CucableLogger logger) {
        this.fileIO = fileIO;
        this.propertyManager = propertyManager;
        this.logger = logger;
    }

    public String getRenderedRunnerFileContent(FeatureRunner featureRunner) throws CucablePluginException {
        String runnerTemplatePath = featureRunner.getRunnerTemplatePath();
        String runnerClassName = featureRunner.getRunnerClassName();
        String fileString = this.fileIO.readContentFromFile(runnerTemplatePath);
        this.checkForPlaceholderErrors(fileString);
        if (runnerTemplatePath.trim().toLowerCase().endsWith(".java")) {
            fileString = this.replaceJavaTemplatePlaceholders(runnerTemplatePath, runnerClassName, fileString);
        }
        fileString = this.replaceFeatureFilePlaceholder(fileString, featureRunner.getFeatureFileNames());
        fileString = fileString.replace(CUCABLE_RUNNER_PLACEHOLDER, runnerClassName);
        fileString = this.replaceCustomParameters(fileString);
        fileString = this.addCucableInfo(fileString, runnerTemplatePath);
        return fileString;
    }

    private void checkForPlaceholderErrors(String runnerFileContentString) throws CucablePluginException {
        if (runnerFileContentString.contains(FEATURE_FILE_NAME_PLACEHOLDER)) {
            throw new CucablePluginException("The [FEATURE_FILE_NAME] placeholder is deprecated. Please use [CUCABLE:FEATURE] or [CUCABLE:RUNNER] accordingly.");
        }
        String regex = "\\[CUCABLE:FEATURE]";
        Pattern pattern = Pattern.compile("\\[CUCABLE:FEATURE]", 8);
        Matcher matcher = pattern.matcher(runnerFileContentString);
        if (!matcher.find()) {
            throw new CucablePluginException("At least one [CUCABLE:FEATURE] placeholder is needed in your template.");
        }
    }

    private String replaceCustomParameters(String runnerFileContentString) {
        String resultString = runnerFileContentString;
        Map<String, String> customPlaceholders = this.propertyManager.getCustomPlaceholders();
        if (customPlaceholders != null) {
            for (Map.Entry<String, String> customPlaceholder : customPlaceholders.entrySet()) {
                String placeholder = String.format(CUCABLE_CUSTOM_PLACEHOLDER, customPlaceholder.getKey().trim());
                String newResultString = resultString.replace(placeholder, customPlaceholder.getValue());
                if (newResultString.equals(resultString)) {
                    this.logger.warn("Custom placeholder '" + placeholder + "' could not be found in your Cucable template.");
                }
                resultString = newResultString;
            }
        }
        return resultString;
    }

    private String replaceFeatureFilePlaceholder(String runnerFileContentString, List<String> featureFileNames) {
        String regex = "(\".*\\[CUCABLE:FEATURE]).*\"";
        Pattern pattern = Pattern.compile("(\".*\\[CUCABLE:FEATURE]).*\"", 8);
        Matcher matcher = pattern.matcher(runnerFileContentString);
        if (!matcher.find()) {
            return runnerFileContentString;
        }
        String fullCucableFeaturePlaceholder = matcher.group(0);
        StringBuilder completeFeatureStringBuilder = new StringBuilder();
        for (int i = 0; i < featureFileNames.size(); ++i) {
            String featureFileName = featureFileNames.get(i);
            completeFeatureStringBuilder.append(fullCucableFeaturePlaceholder.replace(CUCABLE_FEATURE_PLACEHOLDER, featureFileName));
            if (i >= featureFileNames.size() - 1) continue;
            completeFeatureStringBuilder.append(",\n");
        }
        return runnerFileContentString.replace(fullCucableFeaturePlaceholder, completeFeatureStringBuilder);
    }

    private String addCucableInfo(String runnerFileContentString, String runnerTemplatePath) {
        return runnerFileContentString.concat(System.lineSeparator()).concat(System.lineSeparator()).concat("// Generated by Cucable from ").concat(runnerTemplatePath.replace("\\", "/")).concat(System.lineSeparator());
    }

    private String replaceJavaTemplatePlaceholders(String runnerTemplatePath, String runnerClassName, String fileString) {
        String javaFileName = Paths.get(runnerTemplatePath, new String[0]).getFileName().toString();
        String javaFileNameWithoutExtension = javaFileName.substring(0, javaFileName.lastIndexOf(46));
        String replacedFileString = fileString.replace(javaFileNameWithoutExtension, runnerClassName);
        replacedFileString = replacedFileString.replaceAll("package .*;", "");
        return replacedFileString;
    }
}

