/*********************************************************************************
 * Copyright 2015-present trivago GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **********************************************************************************/

package com.trivago.triava.annotations;

/**
 * Documents whether a certain method is time zone aware.
 */
public @interface TimeZoneAware
{
	enum State
	{
		/**
		 * Time zone doesn't matter. Method does not use time zone relevant methods or objects.
		 */
		Independent,
		/**
		 * The method is aware and treats the time zone as documented.
		 */
		Aware,
		/**
		 * The time zone is not taken into account. The default time zone is used.
		 */
		NotAware,
		/**
		 * The method includes time functionality, but has not yet been checked.
		 */
		CheckPending
	}

	String comment() default "";

	/**
	 * 
	 * @return Whether the method is aware of time zones
	 */
	State aware();
}
