/*********************************************************************************
 * Copyright 2015-present trivago GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **********************************************************************************/

package com.trivago.triava.tcache.event;

public enum DispatchMode
{
	/**
	 * Synchronous event with each generated event. Excactly one event per dispatch
	 */
	SYNC(false),
	/**
	 * Asynchronous, time based event dispatching.
	 */
	ASYNC_TIMED(true),
	/**
	 * Multiple events per dispatch.
	 */
	COUNTED(true);

	boolean async;

	DispatchMode(boolean async)
	{
		this.async = async;
	}

	public boolean isAsync()
	{
		return async;
	}
}