/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.api;

import com.google.gson.reflect.TypeToken;
import com.trulioo.normalizedapi.ApiCallback;
import com.trulioo.normalizedapi.ApiClient;
import com.trulioo.normalizedapi.ApiException;
import com.trulioo.normalizedapi.ApiResponse;
import com.trulioo.normalizedapi.Configuration;
import com.trulioo.normalizedapi.Pair;
import com.trulioo.normalizedapi.model.BusinessRegistrationNumber;
import com.trulioo.normalizedapi.model.BusinessSearchRequest;
import com.trulioo.normalizedapi.model.BusinessSearchResponse;
import com.trulioo.normalizedapi.model.BusinessVerifyRequest;
import com.trulioo.normalizedapi.model.CountrySubdivision;
import com.trulioo.normalizedapi.model.VerifyResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;

public class BusinessApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BusinessApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BusinessApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call businessSearchCall(BusinessSearchRequest businessSearchRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BusinessSearchRequest localVarPostBody = businessSearchRequest;
        String localVarPath = "/v3/business/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call businessSearchValidateBeforeCall(BusinessSearchRequest businessSearchRequest, ApiCallback _callback) throws ApiException {
        return this.businessSearchCall(businessSearchRequest, _callback);
    }

    public BusinessSearchResponse businessSearch(BusinessSearchRequest businessSearchRequest) throws ApiException {
        ApiResponse<BusinessSearchResponse> localVarResp = this.businessSearchWithHttpInfo(businessSearchRequest);
        return localVarResp.getData();
    }

    public ApiResponse<BusinessSearchResponse> businessSearchWithHttpInfo(BusinessSearchRequest businessSearchRequest) throws ApiException {
        Call localVarCall = this.businessSearchValidateBeforeCall(businessSearchRequest, null);
        Type localVarReturnType = new TypeToken<BusinessSearchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call businessSearchAsync(BusinessSearchRequest businessSearchRequest, ApiCallback<BusinessSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.businessSearchValidateBeforeCall(businessSearchRequest, _callback);
        Type localVarReturnType = new TypeToken<BusinessSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call businessVerifyCall(BusinessVerifyRequest businessVerifyRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BusinessVerifyRequest localVarPostBody = businessVerifyRequest;
        String localVarPath = "/v3/business/verify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call businessVerifyValidateBeforeCall(BusinessVerifyRequest businessVerifyRequest, ApiCallback _callback) throws ApiException {
        return this.businessVerifyCall(businessVerifyRequest, _callback);
    }

    public VerifyResult businessVerify(BusinessVerifyRequest businessVerifyRequest) throws ApiException {
        ApiResponse<VerifyResult> localVarResp = this.businessVerifyWithHttpInfo(businessVerifyRequest);
        return localVarResp.getData();
    }

    public ApiResponse<VerifyResult> businessVerifyWithHttpInfo(BusinessVerifyRequest businessVerifyRequest) throws ApiException {
        Call localVarCall = this.businessVerifyValidateBeforeCall(businessVerifyRequest, null);
        Type localVarReturnType = new TypeToken<VerifyResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call businessVerifyAsync(BusinessVerifyRequest businessVerifyRequest, ApiCallback<VerifyResult> _callback) throws ApiException {
        Call localVarCall = this.businessVerifyValidateBeforeCall(businessVerifyRequest, _callback);
        Type localVarReturnType = new TypeToken<VerifyResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBusinessRegistrationNumbersCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/business/businessregistrationnumbers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBusinessRegistrationNumbersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getBusinessRegistrationNumbersCall(_callback);
    }

    public List<BusinessRegistrationNumber> getBusinessRegistrationNumbers() throws ApiException {
        ApiResponse<List<BusinessRegistrationNumber>> localVarResp = this.getBusinessRegistrationNumbersWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<BusinessRegistrationNumber>> getBusinessRegistrationNumbersWithHttpInfo() throws ApiException {
        Call localVarCall = this.getBusinessRegistrationNumbersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<BusinessRegistrationNumber>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBusinessRegistrationNumbersAsync(ApiCallback<List<BusinessRegistrationNumber>> _callback) throws ApiException {
        Call localVarCall = this.getBusinessRegistrationNumbersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<BusinessRegistrationNumber>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBusinessRegistrationNumbersWithParametersCall(String countryCode, String jurisdictionCode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/business/businessregistrationnumbers";
        List<String> resources = Arrays.asList(countryCode, jurisdictionCode);
        for (String x : resources) {
            if (StringUtils.isBlank((CharSequence)x)) continue;
            localVarPath = localVarPath + "/" + this.localVarApiClient.escapeString(x);
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBusinessRegistrationNumbersWithParametersValidateBeforeCall(String countryCode, String jurisdictionCode, ApiCallback _callback) throws ApiException {
        if (StringUtils.isBlank((CharSequence)countryCode) && !StringUtils.isBlank((CharSequence)jurisdictionCode)) {
            throw new ApiException("The parameter 'countryCode' is required in order to use the parameter 'jurisdictionCode' when calling getBusinessRegistrationNumbers(Async)");
        }
        return this.getBusinessRegistrationNumbersWithParametersCall(countryCode, jurisdictionCode, _callback);
    }

    public List<BusinessRegistrationNumber> getBusinessRegistrationNumbersWithParameters(String countryCode, String jurisdictionCode) throws ApiException {
        ApiResponse<List<BusinessRegistrationNumber>> localVarResp = this.getBusinessRegistrationNumbersWithParametersWithHttpInfo(countryCode, jurisdictionCode);
        return localVarResp.getData();
    }

    public ApiResponse<List<BusinessRegistrationNumber>> getBusinessRegistrationNumbersWithParametersWithHttpInfo(String countryCode, String jurisdictionCode) throws ApiException {
        Call localVarCall = this.getBusinessRegistrationNumbersWithParametersValidateBeforeCall(countryCode, jurisdictionCode, null);
        Type localVarReturnType = new TypeToken<List<BusinessRegistrationNumber>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBusinessRegistrationNumbersWithParametersAsync(String countryCode, String jurisdictionCode, ApiCallback<List<BusinessRegistrationNumber>> _callback) throws ApiException {
        Call localVarCall = this.getBusinessRegistrationNumbersWithParametersValidateBeforeCall(countryCode, jurisdictionCode, _callback);
        Type localVarReturnType = new TypeToken<List<BusinessRegistrationNumber>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCountryJOICall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/business/countryJOI/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCountryJOIValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCountryJOICall(_callback);
    }

    public List<CountrySubdivision> getCountryJOI() throws ApiException {
        ApiResponse<List<CountrySubdivision>> localVarResp = this.getCountryJOIWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<CountrySubdivision>> getCountryJOIWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCountryJOIValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCountryJOIAsync(ApiCallback<List<CountrySubdivision>> _callback) throws ApiException {
        Call localVarCall = this.getCountryJOIValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCountryJOIWithCountryCodeCall(String countryCode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/business/countryJOI/{countryCode}".replace("{countryCode}", this.localVarApiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oAuth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCountryJOIWithCountryCodeValidateBeforeCall(String countryCode, ApiCallback _callback) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getCountryJOIWithCountryCode(Async)");
        }
        return this.getCountryJOIWithCountryCodeCall(countryCode, _callback);
    }

    public List<CountrySubdivision> getCountryJOIWithCountryCode(String countryCode) throws ApiException {
        ApiResponse<List<CountrySubdivision>> localVarResp = this.getCountryJOIWithCountryCodeWithHttpInfo(countryCode);
        return localVarResp.getData();
    }

    public ApiResponse<List<CountrySubdivision>> getCountryJOIWithCountryCodeWithHttpInfo(String countryCode) throws ApiException {
        Call localVarCall = this.getCountryJOIWithCountryCodeValidateBeforeCall(countryCode, null);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCountryJOIWithCountryCodeAsync(String countryCode, ApiCallback<List<CountrySubdivision>> _callback) throws ApiException {
        Call localVarCall = this.getCountryJOIWithCountryCodeValidateBeforeCall(countryCode, _callback);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

