/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.auth;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponseFactory;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class OAuthOkHttpClient
implements HttpClient {
    private OkHttpClient client;
    private boolean verifyingSsl;

    public OAuthOkHttpClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public OAuthOkHttpClient() {
        this.client = new OkHttpClient();
    }

    public OAuthOkHttpClient(OkHttpClient client) {
        this.client = client;
    }

    public <T extends OAuthClientResponse> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        MediaType mediaType = MediaType.parse((String)"application/json");
        Request.Builder requestBuilder = new Request.Builder().url(request.getLocationUri());
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("Content-Type")) {
                    mediaType = MediaType.parse((String)entry.getValue());
                    continue;
                }
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestBody body = request.getBody() != null ? RequestBody.create((String)request.getBody(), (MediaType)mediaType) : null;
        requestBuilder.method(requestMethod, body);
        try {
            Response response = this.client.newCall(requestBuilder.build()).execute();
            return (T)OAuthClientResponseFactory.createCustomResponse((String)response.body().string(), (String)response.body().contentType().toString(), (int)response.code(), (Map)response.headers().toMultimap(), responseClass);
        }
        catch (IOException e) {
            throw new OAuthSystemException((Throwable)e);
        }
    }

    private void applySslSettings() {
        try {
            Object hostnameVerifier;
            TrustManager[] trustManagers;
            if (!this.verifyingSsl) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagers = trustManagerFactory.getTrustManagers();
                hostnameVerifier = OkHostnameVerifier.INSTANCE;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
            this.client = this.client.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).hostnameVerifier((HostnameVerifier)hostnameVerifier).build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
    }
}

