/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.trulioo.normalizedapi.JSON;
import com.trulioo.normalizedapi.model.BusinessResult;
import com.trulioo.normalizedapi.model.ServiceError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class BusinessRecord {
    public static final String SERIALIZED_NAME_TRANSACTION_RECORD_I_D = "TransactionRecordID";
    @SerializedName(value="TransactionRecordID")
    private String transactionRecordID;
    public static final String SERIALIZED_NAME_RECORD_STATUS = "RecordStatus";
    @SerializedName(value="RecordStatus")
    private String recordStatus;
    public static final String SERIALIZED_NAME_DATASOURCE_RESULTS = "DatasourceResults";
    @SerializedName(value="DatasourceResults")
    private List<BusinessResult> datasourceResults;
    public static final String SERIALIZED_NAME_ERRORS = "Errors";
    @SerializedName(value="Errors")
    private List<ServiceError> errors;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BusinessRecord transactionRecordID(String transactionRecordID) {
        this.transactionRecordID = transactionRecordID;
        return this;
    }

    @Nullable
    public String getTransactionRecordID() {
        return this.transactionRecordID;
    }

    public void setTransactionRecordID(String transactionRecordID) {
        this.transactionRecordID = transactionRecordID;
    }

    public BusinessRecord recordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
        return this;
    }

    @Nullable
    public String getRecordStatus() {
        return this.recordStatus;
    }

    public void setRecordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
    }

    public BusinessRecord datasourceResults(List<BusinessResult> datasourceResults) {
        this.datasourceResults = datasourceResults;
        return this;
    }

    public BusinessRecord addDatasourceResultsItem(BusinessResult datasourceResultsItem) {
        if (this.datasourceResults == null) {
            this.datasourceResults = new ArrayList<BusinessResult>();
        }
        this.datasourceResults.add(datasourceResultsItem);
        return this;
    }

    @Nullable
    public List<BusinessResult> getDatasourceResults() {
        return this.datasourceResults;
    }

    public void setDatasourceResults(List<BusinessResult> datasourceResults) {
        this.datasourceResults = datasourceResults;
    }

    public BusinessRecord errors(List<ServiceError> errors) {
        this.errors = errors;
        return this;
    }

    public BusinessRecord addErrorsItem(ServiceError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ServiceError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    public List<ServiceError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ServiceError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessRecord businessRecord = (BusinessRecord)o;
        return Objects.equals(this.transactionRecordID, businessRecord.transactionRecordID) && Objects.equals(this.recordStatus, businessRecord.recordStatus) && Objects.equals(this.datasourceResults, businessRecord.datasourceResults) && Objects.equals(this.errors, businessRecord.errors);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.transactionRecordID, this.recordStatus, this.datasourceResults, this.errors);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessRecord {\n");
        sb.append("    transactionRecordID: ").append(this.toIndentedString(this.transactionRecordID)).append("\n");
        sb.append("    recordStatus: ").append(this.toIndentedString(this.recordStatus)).append("\n");
        sb.append("    datasourceResults: ").append(this.toIndentedString(this.datasourceResults)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayerrors;
        JsonArray jsonArraydatasourceResults;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in BusinessRecord is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BusinessRecord` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_RECORD_I_D) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_RECORD_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_RECORD_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `TransactionRecordID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_RECORD_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECORD_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_RECORD_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RECORD_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `RecordStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECORD_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATASOURCE_RESULTS) != null && !jsonObj.get(SERIALIZED_NAME_DATASOURCE_RESULTS).isJsonNull() && (jsonArraydatasourceResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATASOURCE_RESULTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATASOURCE_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `DatasourceResults` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATASOURCE_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArraydatasourceResults.size(); ++i) {
                BusinessResult.validateJsonObject(jsonArraydatasourceResults.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ERRORS) != null && !jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonNull() && (jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                ServiceError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static BusinessRecord fromJson(String jsonString) throws IOException {
        return (BusinessRecord)JSON.getGson().fromJson(jsonString, BusinessRecord.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_RECORD_I_D);
        openapiFields.add(SERIALIZED_NAME_RECORD_STATUS);
        openapiFields.add(SERIALIZED_NAME_DATASOURCE_RESULTS);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BusinessRecord.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BusinessRecord.class));
            return new TypeAdapter<BusinessRecord>(){

                public void write(JsonWriter out, BusinessRecord value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BusinessRecord read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BusinessRecord.validateJsonObject(jsonObj);
                    return (BusinessRecord)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

