/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.trulioo.normalizedapi.JSON;
import com.trulioo.normalizedapi.model.Result;
import com.trulioo.normalizedapi.model.ServiceError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class BusinessResult {
    public static final String SERIALIZED_NAME_RESULTS = "Results";
    @SerializedName(value="Results")
    private List<Result> results;
    public static final String SERIALIZED_NAME_DATASOURCE_NAME = "DatasourceName";
    @SerializedName(value="DatasourceName")
    private String datasourceName;
    public static final String SERIALIZED_NAME_ERRORS = "Errors";
    @SerializedName(value="Errors")
    private List<ServiceError> errors;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BusinessResult() {
    }

    public BusinessResult(List<ServiceError> errors) {
        this();
        this.errors = errors;
    }

    public BusinessResult results(List<Result> results) {
        this.results = results;
        return this;
    }

    public BusinessResult addResultsItem(Result resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<Result>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nullable
    public List<Result> getResults() {
        return this.results;
    }

    public void setResults(List<Result> results) {
        this.results = results;
    }

    public BusinessResult datasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        return this;
    }

    @Nullable
    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    @Nullable
    public List<ServiceError> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessResult businessResult = (BusinessResult)o;
        return Objects.equals(this.results, businessResult.results) && Objects.equals(this.datasourceName, businessResult.datasourceName) && Objects.equals(this.errors, businessResult.errors);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.results, this.datasourceName, this.errors);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessResult {\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    datasourceName: ").append(this.toIndentedString(this.datasourceName)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayerrors;
        JsonArray jsonArrayresults;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in BusinessResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BusinessResult` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULTS) != null && !jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonNull() && (jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArrayresults.size(); ++i) {
                Result.validateJsonObject(jsonArrayresults.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DATASOURCE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DATASOURCE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DATASOURCE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `DatasourceName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATASOURCE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERRORS) != null && !jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonNull() && (jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                ServiceError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static BusinessResult fromJson(String jsonString) throws IOException {
        return (BusinessResult)JSON.getGson().fromJson(jsonString, BusinessResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiFields.add(SERIALIZED_NAME_DATASOURCE_NAME);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BusinessResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BusinessResult.class));
            return new TypeAdapter<BusinessResult>(){

                public void write(JsonWriter out, BusinessResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BusinessResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BusinessResult.validateJsonObject(jsonObj);
                    return (BusinessResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

