/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.trulioo.normalizedapi.JSON;
import com.trulioo.normalizedapi.model.DataFields;
import com.trulioo.normalizedapi.model.ServiceError;
import com.trulioo.normalizedapi.model.VerifyRequestMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class VerifyRequest {
    public static final String SERIALIZED_NAME_VERIFICATION_TYPE = "VerificationType";
    @SerializedName(value="VerificationType")
    private VerificationTypeEnum verificationType;
    public static final String SERIALIZED_NAME_PACKAGE_ID = "PackageId";
    @SerializedName(value="PackageId")
    private String packageId;
    public static final String SERIALIZED_NAME_CALL_BACK_URL = "CallBackUrl";
    @SerializedName(value="CallBackUrl")
    private String callBackUrl;
    public static final String SERIALIZED_NAME_TIMEOUT = "Timeout";
    @SerializedName(value="Timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_CLEANSED_ADDRESS = "CleansedAddress";
    @SerializedName(value="CleansedAddress")
    private Boolean cleansedAddress;
    public static final String SERIALIZED_NAME_CONSENT_FOR_DATA_SOURCES = "ConsentForDataSources";
    @SerializedName(value="ConsentForDataSources")
    private List<String> consentForDataSources;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "CountryCode";
    @SerializedName(value="CountryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D = "CustomerReferenceID";
    @SerializedName(value="CustomerReferenceID")
    private String customerReferenceID;
    public static final String SERIALIZED_NAME_DATA_FIELDS = "DataFields";
    @SerializedName(value="DataFields")
    private DataFields dataFields;
    public static final String SERIALIZED_NAME_REQUEST_ERRORS = "RequestErrors";
    @SerializedName(value="RequestErrors")
    private List<ServiceError> requestErrors;
    public static final String SERIALIZED_NAME_VERBOSE_MODE = "VerboseMode";
    @SerializedName(value="VerboseMode")
    private Boolean verboseMode = false;
    public static final String SERIALIZED_NAME_REQUEST_METADATA = "RequestMetadata";
    @SerializedName(value="RequestMetadata")
    private List<VerifyRequestMetadata> requestMetadata;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VerifyRequest verificationType(VerificationTypeEnum verificationType) {
        this.verificationType = verificationType;
        return this;
    }

    @Nullable
    public VerificationTypeEnum getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(VerificationTypeEnum verificationType) {
        this.verificationType = verificationType;
    }

    public VerifyRequest packageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    @Nullable
    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public VerifyRequest callBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }

    @Nullable
    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }

    public VerifyRequest timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public VerifyRequest cleansedAddress(Boolean cleansedAddress) {
        this.cleansedAddress = cleansedAddress;
        return this;
    }

    @Nullable
    public Boolean getCleansedAddress() {
        return this.cleansedAddress;
    }

    public void setCleansedAddress(Boolean cleansedAddress) {
        this.cleansedAddress = cleansedAddress;
    }

    public VerifyRequest consentForDataSources(List<String> consentForDataSources) {
        this.consentForDataSources = consentForDataSources;
        return this;
    }

    public VerifyRequest addConsentForDataSourcesItem(String consentForDataSourcesItem) {
        if (this.consentForDataSources == null) {
            this.consentForDataSources = new ArrayList<String>();
        }
        this.consentForDataSources.add(consentForDataSourcesItem);
        return this;
    }

    @Nullable
    public List<String> getConsentForDataSources() {
        return this.consentForDataSources;
    }

    public void setConsentForDataSources(List<String> consentForDataSources) {
        this.consentForDataSources = consentForDataSources;
    }

    public VerifyRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public VerifyRequest customerReferenceID(String customerReferenceID) {
        this.customerReferenceID = customerReferenceID;
        return this;
    }

    @Nullable
    public String getCustomerReferenceID() {
        return this.customerReferenceID;
    }

    public void setCustomerReferenceID(String customerReferenceID) {
        this.customerReferenceID = customerReferenceID;
    }

    public VerifyRequest dataFields(DataFields dataFields) {
        this.dataFields = dataFields;
        return this;
    }

    @Nullable
    public DataFields getDataFields() {
        return this.dataFields;
    }

    public void setDataFields(DataFields dataFields) {
        this.dataFields = dataFields;
    }

    public VerifyRequest requestErrors(List<ServiceError> requestErrors) {
        this.requestErrors = requestErrors;
        return this;
    }

    public VerifyRequest addRequestErrorsItem(ServiceError requestErrorsItem) {
        if (this.requestErrors == null) {
            this.requestErrors = new ArrayList<ServiceError>();
        }
        this.requestErrors.add(requestErrorsItem);
        return this;
    }

    @Nullable
    public List<ServiceError> getRequestErrors() {
        return this.requestErrors;
    }

    public void setRequestErrors(List<ServiceError> requestErrors) {
        this.requestErrors = requestErrors;
    }

    public VerifyRequest verboseMode(Boolean verboseMode) {
        this.verboseMode = verboseMode;
        return this;
    }

    @Nullable
    public Boolean getVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(Boolean verboseMode) {
        this.verboseMode = verboseMode;
    }

    public VerifyRequest requestMetadata(List<VerifyRequestMetadata> requestMetadata) {
        this.requestMetadata = requestMetadata;
        return this;
    }

    public VerifyRequest addRequestMetadataItem(VerifyRequestMetadata requestMetadataItem) {
        if (this.requestMetadata == null) {
            this.requestMetadata = new ArrayList<VerifyRequestMetadata>();
        }
        this.requestMetadata.add(requestMetadataItem);
        return this;
    }

    @Nullable
    public List<VerifyRequestMetadata> getRequestMetadata() {
        return this.requestMetadata;
    }

    public void setRequestMetadata(List<VerifyRequestMetadata> requestMetadata) {
        this.requestMetadata = requestMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyRequest verifyRequest = (VerifyRequest)o;
        return Objects.equals((Object)this.verificationType, (Object)verifyRequest.verificationType) && Objects.equals(this.packageId, verifyRequest.packageId) && Objects.equals(this.callBackUrl, verifyRequest.callBackUrl) && Objects.equals(this.timeout, verifyRequest.timeout) && Objects.equals(this.cleansedAddress, verifyRequest.cleansedAddress) && Objects.equals(this.consentForDataSources, verifyRequest.consentForDataSources) && Objects.equals(this.countryCode, verifyRequest.countryCode) && Objects.equals(this.customerReferenceID, verifyRequest.customerReferenceID) && Objects.equals(this.dataFields, verifyRequest.dataFields) && Objects.equals(this.requestErrors, verifyRequest.requestErrors) && Objects.equals(this.verboseMode, verifyRequest.verboseMode) && Objects.equals(this.requestMetadata, verifyRequest.requestMetadata);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.verificationType, this.packageId, this.callBackUrl, this.timeout, this.cleansedAddress, this.consentForDataSources, this.countryCode, this.customerReferenceID, this.dataFields, this.requestErrors, this.verboseMode, this.requestMetadata});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyRequest {\n");
        sb.append("    verificationType: ").append(this.toIndentedString((Object)this.verificationType)).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    callBackUrl: ").append(this.toIndentedString(this.callBackUrl)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    cleansedAddress: ").append(this.toIndentedString(this.cleansedAddress)).append("\n");
        sb.append("    consentForDataSources: ").append(this.toIndentedString(this.consentForDataSources)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    customerReferenceID: ").append(this.toIndentedString(this.customerReferenceID)).append("\n");
        sb.append("    dataFields: ").append(this.toIndentedString(this.dataFields)).append("\n");
        sb.append("    requestErrors: ").append(this.toIndentedString(this.requestErrors)).append("\n");
        sb.append("    verboseMode: ").append(this.toIndentedString(this.verboseMode)).append("\n");
        sb.append("    requestMetadata: ").append(this.toIndentedString(this.requestMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayrequestMetadata;
        JsonArray jsonArrayrequestErrors;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in VerifyRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `VerifyRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFICATION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_VERIFICATION_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERIFICATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `VerificationType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PACKAGE_ID) != null && !jsonObj.get(SERIALIZED_NAME_PACKAGE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PACKAGE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PackageId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PACKAGE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALL_BACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALL_BACK_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CALL_BACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CallBackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALL_BACK_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSENT_FOR_DATA_SOURCES) != null && !jsonObj.get(SERIALIZED_NAME_CONSENT_FOR_DATA_SOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ConsentForDataSources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSENT_FOR_DATA_SOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CountryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CustomerReferenceID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_DATA_FIELDS).isJsonNull()) {
            DataFields.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DATA_FIELDS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUEST_ERRORS) != null && !jsonObj.get(SERIALIZED_NAME_REQUEST_ERRORS).isJsonNull() && (jsonArrayrequestErrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUEST_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUEST_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `RequestErrors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayrequestErrors.size(); ++i) {
                ServiceError.validateJsonObject(jsonArrayrequestErrors.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUEST_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_REQUEST_METADATA).isJsonNull() && (jsonArrayrequestMetadata = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUEST_METADATA)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUEST_METADATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `RequestMetadata` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_METADATA).toString()));
            }
            for (int i = 0; i < jsonArrayrequestMetadata.size(); ++i) {
                VerifyRequestMetadata.validateJsonObject(jsonArrayrequestMetadata.get(i).getAsJsonObject());
            }
        }
    }

    public static VerifyRequest fromJson(String jsonString) throws IOException {
        return (VerifyRequest)JSON.getGson().fromJson(jsonString, VerifyRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_PACKAGE_ID);
        openapiFields.add(SERIALIZED_NAME_CALL_BACK_URL);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_CLEANSED_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CONSENT_FOR_DATA_SOURCES);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_CUSTOMER_REFERENCE_I_D);
        openapiFields.add(SERIALIZED_NAME_DATA_FIELDS);
        openapiFields.add(SERIALIZED_NAME_REQUEST_ERRORS);
        openapiFields.add(SERIALIZED_NAME_VERBOSE_MODE);
        openapiFields.add(SERIALIZED_NAME_REQUEST_METADATA);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationTypeEnum {
        LIVE("Live"),
        DEMO("Demo"),
        TEST("Test");

        private String value;

        private VerificationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationTypeEnum fromValue(String value) {
            for (VerificationTypeEnum b : VerificationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationTypeEnum> {
            public void write(JsonWriter jsonWriter, VerificationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationTypeEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VerifyRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VerifyRequest.class));
            return new TypeAdapter<VerifyRequest>(){

                public void write(JsonWriter out, VerifyRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VerifyRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VerifyRequest.validateJsonObject(jsonObj);
                    return (VerifyRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

