/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import okio.ByteString;

class ByteArrayAdapter
extends TypeAdapter<byte[]> {
    ByteArrayAdapter() {
    }

    public void write(JsonWriter out, byte[] value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(ByteString.of((byte[])value).base64());
        }
    }

    public byte[] read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        String bytesAsBase64 = in.nextString();
        ByteString byteString = ByteString.decodeBase64((String)bytesAsBase64);
        return byteString.toByteArray();
    }
}

