/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.trulioo.normalizedapi.ApiClient;
import com.trulioo.normalizedapi.ByteArrayAdapter;
import com.trulioo.normalizedapi.DateAdapter;
import com.trulioo.normalizedapi.DateTimeTypeAdapter;
import com.trulioo.normalizedapi.LocalDateTypeAdapter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class JSON {
    private ApiClient apiClient;
    private Gson gson;

    public JSON(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAdapter(apiClient)).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateTypeAdapter()).registerTypeAdapter(byte[].class, (Object)new ByteArrayAdapter()).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String serialize(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T deserialize(String body, Type returnType) {
        try {
            if (this.apiClient.isLenientOnJson()) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)this.gson.fromJson(jsonReader, returnType);
            }
            return (T)this.gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            if (returnType.equals(Date.class)) {
                return (T)this.apiClient.parseDateOrDatetime(body);
            }
            throw e;
        }
    }
}

