/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.api;

import com.google.gson.reflect.TypeToken;
import com.trulioo.normalizedapi.ApiCallback;
import com.trulioo.normalizedapi.ApiClient;
import com.trulioo.normalizedapi.ApiException;
import com.trulioo.normalizedapi.ApiResponse;
import com.trulioo.normalizedapi.Configuration;
import com.trulioo.normalizedapi.Pair;
import com.trulioo.normalizedapi.ProgressRequestBody;
import com.trulioo.normalizedapi.ProgressResponseBody;
import com.trulioo.normalizedapi.model.Consent;
import com.trulioo.normalizedapi.model.CountrySubdivision;
import com.trulioo.normalizedapi.model.DataFields;
import com.trulioo.normalizedapi.model.NormalizedDatasourceGroupCountry;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ConfigurationApi {
    private ApiClient apiClient;

    public ConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getConsentsCall(String countryCode, String configurationName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/consents/{configurationName}/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString())).replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getConsentsValidateBeforeCall(String countryCode, String configurationName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getConsents(Async)");
        }
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getConsents(Async)");
        }
        Call call = this.getConsentsCall(countryCode, configurationName, progressListener, progressRequestListener);
        return call;
    }

    public List<String> getConsents(String countryCode, String configurationName) throws ApiException {
        ApiResponse<List<String>> resp = this.getConsentsWithHttpInfo(countryCode, configurationName);
        return resp.getData();
    }

    public ApiResponse<List<String>> getConsentsWithHttpInfo(String countryCode, String configurationName) throws ApiException {
        Call call = this.getConsentsValidateBeforeCall(countryCode, configurationName, null, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getConsentsAsync(String countryCode, String configurationName, final ApiCallback<List<String>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getConsentsValidateBeforeCall(countryCode, configurationName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCountryCodesCall(String configurationName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/countrycodes/{configurationName}".replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCountryCodesValidateBeforeCall(String configurationName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getCountryCodes(Async)");
        }
        Call call = this.getCountryCodesCall(configurationName, progressListener, progressRequestListener);
        return call;
    }

    public List<String> getCountryCodes(String configurationName) throws ApiException {
        ApiResponse<List<String>> resp = this.getCountryCodesWithHttpInfo(configurationName);
        return resp.getData();
    }

    public ApiResponse<List<String>> getCountryCodesWithHttpInfo(String configurationName) throws ApiException {
        Call call = this.getCountryCodesValidateBeforeCall(configurationName, null, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCountryCodesAsync(String configurationName, final ApiCallback<List<String>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCountryCodesValidateBeforeCall(configurationName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCountrySubdivisionsCall(String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/countrysubdivisions/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCountrySubdivisionsValidateBeforeCall(String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getCountrySubdivisions(Async)");
        }
        Call call = this.getCountrySubdivisionsCall(countryCode, progressListener, progressRequestListener);
        return call;
    }

    public List<CountrySubdivision> getCountrySubdivisions(String countryCode) throws ApiException {
        ApiResponse<List<CountrySubdivision>> resp = this.getCountrySubdivisionsWithHttpInfo(countryCode);
        return resp.getData();
    }

    public ApiResponse<List<CountrySubdivision>> getCountrySubdivisionsWithHttpInfo(String countryCode) throws ApiException {
        Call call = this.getCountrySubdivisionsValidateBeforeCall(countryCode, null, null);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCountrySubdivisionsAsync(String countryCode, final ApiCallback<List<CountrySubdivision>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCountrySubdivisionsValidateBeforeCall(countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<CountrySubdivision>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDatasourcesCall(String configurationName, String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/datasources/{configurationName}/{countryCode}".replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString())).replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDatasourcesValidateBeforeCall(String configurationName, String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getDatasources(Async)");
        }
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getDatasources(Async)");
        }
        Call call = this.getDatasourcesCall(configurationName, countryCode, progressListener, progressRequestListener);
        return call;
    }

    public List<NormalizedDatasourceGroupCountry> getDatasources(String configurationName, String countryCode) throws ApiException {
        ApiResponse<List<NormalizedDatasourceGroupCountry>> resp = this.getDatasourcesWithHttpInfo(configurationName, countryCode);
        return resp.getData();
    }

    public ApiResponse<List<NormalizedDatasourceGroupCountry>> getDatasourcesWithHttpInfo(String configurationName, String countryCode) throws ApiException {
        Call call = this.getDatasourcesValidateBeforeCall(configurationName, countryCode, null, null);
        Type localVarReturnType = new TypeToken<List<NormalizedDatasourceGroupCountry>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDatasourcesAsync(String configurationName, String countryCode, final ApiCallback<List<NormalizedDatasourceGroupCountry>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDatasourcesValidateBeforeCall(configurationName, countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<NormalizedDatasourceGroupCountry>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDetailedConsentsCall(String countryCode, String configurationName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/detailedConsents/{configurationName}/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString())).replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDetailedConsentsValidateBeforeCall(String countryCode, String configurationName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getDetailedConsents(Async)");
        }
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getDetailedConsents(Async)");
        }
        Call call = this.getDetailedConsentsCall(countryCode, configurationName, progressListener, progressRequestListener);
        return call;
    }

    public List<Consent> getDetailedConsents(String countryCode, String configurationName) throws ApiException {
        ApiResponse<List<Consent>> resp = this.getDetailedConsentsWithHttpInfo(countryCode, configurationName);
        return resp.getData();
    }

    public ApiResponse<List<Consent>> getDetailedConsentsWithHttpInfo(String countryCode, String configurationName) throws ApiException {
        Call call = this.getDetailedConsentsValidateBeforeCall(countryCode, configurationName, null, null);
        Type localVarReturnType = new TypeToken<List<Consent>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDetailedConsentsAsync(String countryCode, String configurationName, final ApiCallback<List<Consent>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDetailedConsentsValidateBeforeCall(countryCode, configurationName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Consent>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDocumentTypesCall(String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/documentTypes/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDocumentTypesValidateBeforeCall(String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getDocumentTypes(Async)");
        }
        Call call = this.getDocumentTypesCall(countryCode, progressListener, progressRequestListener);
        return call;
    }

    public Map<String, List<String>> getDocumentTypes(String countryCode) throws ApiException {
        ApiResponse<Map<String, List<String>>> resp = this.getDocumentTypesWithHttpInfo(countryCode);
        return resp.getData();
    }

    public ApiResponse<Map<String, List<String>>> getDocumentTypesWithHttpInfo(String countryCode) throws ApiException {
        Call call = this.getDocumentTypesValidateBeforeCall(countryCode, null, null);
        Type localVarReturnType = new TypeToken<Map<String, List<String>>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDocumentTypesAsync(String countryCode, final ApiCallback<Map<String, List<String>>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentTypesValidateBeforeCall(countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Map<String, List<String>>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFieldsCall(String countryCode, String configurationName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/fields/{configurationName}/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString())).replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFieldsValidateBeforeCall(String countryCode, String configurationName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getFields(Async)");
        }
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getFields(Async)");
        }
        Call call = this.getFieldsCall(countryCode, configurationName, progressListener, progressRequestListener);
        return call;
    }

    public Object getFields(String countryCode, String configurationName) throws ApiException {
        ApiResponse<Object> resp = this.getFieldsWithHttpInfo(countryCode, configurationName);
        return resp.getData();
    }

    public ApiResponse<Object> getFieldsWithHttpInfo(String countryCode, String configurationName) throws ApiException {
        Call call = this.getFieldsValidateBeforeCall(countryCode, configurationName, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFieldsAsync(String countryCode, String configurationName, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFieldsValidateBeforeCall(countryCode, configurationName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getRecommendedFieldsCall(String countryCode, String configurationName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/recommendedfields/{configurationName}/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString())).replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRecommendedFieldsValidateBeforeCall(String countryCode, String configurationName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getRecommendedFields(Async)");
        }
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getRecommendedFields(Async)");
        }
        Call call = this.getRecommendedFieldsCall(countryCode, configurationName, progressListener, progressRequestListener);
        return call;
    }

    public Object getRecommendedFields(String countryCode, String configurationName) throws ApiException {
        ApiResponse<Object> resp = this.getRecommendedFieldsWithHttpInfo(countryCode, configurationName);
        return resp.getData();
    }

    public ApiResponse<Object> getRecommendedFieldsWithHttpInfo(String countryCode, String configurationName) throws ApiException {
        Call call = this.getRecommendedFieldsValidateBeforeCall(countryCode, configurationName, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRecommendedFieldsAsync(String countryCode, String configurationName, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRecommendedFieldsValidateBeforeCall(countryCode, configurationName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestEntitiesCall(String configurationName, String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/v1/testentities/{configurationName}/{countryCode}".replaceAll("\\{configurationName\\}", this.apiClient.escapeString(configurationName.toString())).replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestEntitiesValidateBeforeCall(String configurationName, String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (configurationName == null) {
            throw new ApiException("Missing the required parameter 'configurationName' when calling getTestEntities(Async)");
        }
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getTestEntities(Async)");
        }
        Call call = this.getTestEntitiesCall(configurationName, countryCode, progressListener, progressRequestListener);
        return call;
    }

    public List<DataFields> getTestEntities(String configurationName, String countryCode) throws ApiException {
        ApiResponse<List<DataFields>> resp = this.getTestEntitiesWithHttpInfo(configurationName, countryCode);
        return resp.getData();
    }

    public ApiResponse<List<DataFields>> getTestEntitiesWithHttpInfo(String configurationName, String countryCode) throws ApiException {
        Call call = this.getTestEntitiesValidateBeforeCall(configurationName, countryCode, null, null);
        Type localVarReturnType = new TypeToken<List<DataFields>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestEntitiesAsync(String configurationName, String countryCode, final ApiCallback<List<DataFields>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestEntitiesValidateBeforeCall(configurationName, countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DataFields>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

