/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="<p>Types of fields you will see here include</p>  <table class=\"help-page-table\">    <thead>      <tr>        <td>          <b>FieldName</b>        </td>        <td>          <b>Data</b>        </td>        <td>          <b>Comments</b>        </td>      </tr>    </thead>    <tbody>      <tr>        <td>WatchlistState</td>        <td>Clear</td>        <td>If the submitted individual did not match any watchlist checks, the appended field data will appear as clear</td>      </tr>      <tr>        <td>WatchlistState</td>        <td>Hit</td>        <td>If the submitted individual triggered a watchlist hit, the watchlistdata field also be included as below:</td>      </tr>      <tr>        <td>WatchlistData</td>        <td>Name|URL\\tName2|URL</td>        <td> Name of the source a pipe (|) the url of the source each source is separated with a tab (\\t )</td>      </tr>      <tr>        <td>CanadaSixMonthResidency</td>        <td>YES</td>        <td>The Canadian Credit Agency provides a flag to indicate that an individual has been at the specified              residence for at least six months.The canadasixmonthresidency field is returned with a value of either YES or NO.</td>      </tr>      <tr>        <td>IsDeceased</td>        <td>False</td>        <td>The IsDeceased field is returned by various datasources to indicate whether the input information was screened against an available death file.              Check with your Trulioo Technical Account Manager to see which datasources support this option.</td>      </tr>      <tr>        <td>IsDeceased</td>        <td>True</td>        <td></td>      </tr>      <tr>        <td>FraudFlag</td>        <td>True</td>        <td></td>      </tr>      <tr>        <td>FraudFlag</td>        <td>False</td>        <td></td>      </tr>    </tbody>  </table>  <p>If you are retrieving transaction with address corrected values you will also see address fields in appended data</p>")
public class AppendedField {
    @SerializedName(value="FieldName")
    private String fieldName = null;
    @SerializedName(value="Data")
    private Object data = null;

    public AppendedField fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public AppendedField data(Object data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="")
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendedField appendedField = (AppendedField)o;
        return Objects.equals(this.fieldName, appendedField.fieldName) && Objects.equals(this.data, appendedField.data);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppendedField {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

