/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import com.trulioo.normalizedapi.model.BusinessResult;
import com.trulioo.normalizedapi.model.ServiceError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BusinessRecord {
    @SerializedName(value="TransactionRecordID")
    private String transactionRecordID = null;
    @SerializedName(value="RecordStatus")
    private String recordStatus = null;
    @SerializedName(value="DatasourceResults")
    private List<BusinessResult> datasourceResults = null;
    @SerializedName(value="Errors")
    private List<ServiceError> errors = null;

    public BusinessRecord transactionRecordID(String transactionRecordID) {
        this.transactionRecordID = transactionRecordID;
        return this;
    }

    @ApiModelProperty(value="The TransactionRecordID, this is the ID you will use to fetch the transaction again.")
    public String getTransactionRecordID() {
        return this.transactionRecordID;
    }

    public void setTransactionRecordID(String transactionRecordID) {
        this.transactionRecordID = transactionRecordID;
    }

    public BusinessRecord recordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
        return this;
    }

    @ApiModelProperty(value="'match' or 'nomatch' if the verification passed the rules configured on your account this will be 'match'.")
    public String getRecordStatus() {
        return this.recordStatus;
    }

    public void setRecordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
    }

    public BusinessRecord datasourceResults(List<BusinessResult> datasourceResults) {
        this.datasourceResults = datasourceResults;
        return this;
    }

    public BusinessRecord addDatasourceResultsItem(BusinessResult datasourceResultsItem) {
        if (this.datasourceResults == null) {
            this.datasourceResults = new ArrayList<BusinessResult>();
        }
        this.datasourceResults.add(datasourceResultsItem);
        return this;
    }

    @ApiModelProperty(value="Results for each datasource that was queried")
    public List<BusinessResult> getDatasourceResults() {
        return this.datasourceResults;
    }

    public void setDatasourceResults(List<BusinessResult> datasourceResults) {
        this.datasourceResults = datasourceResults;
    }

    public BusinessRecord errors(List<ServiceError> errors) {
        this.errors = errors;
        return this;
    }

    public BusinessRecord addErrorsItem(ServiceError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ServiceError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ServiceError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ServiceError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessRecord businessRecord = (BusinessRecord)o;
        return Objects.equals(this.transactionRecordID, businessRecord.transactionRecordID) && Objects.equals(this.recordStatus, businessRecord.recordStatus) && Objects.equals(this.datasourceResults, businessRecord.datasourceResults) && Objects.equals(this.errors, businessRecord.errors);
    }

    public int hashCode() {
        return Objects.hash(this.transactionRecordID, this.recordStatus, this.datasourceResults, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessRecord {\n");
        sb.append("    transactionRecordID: ").append(this.toIndentedString(this.transactionRecordID)).append("\n");
        sb.append("    recordStatus: ").append(this.toIndentedString(this.recordStatus)).append("\n");
        sb.append("    datasourceResults: ").append(this.toIndentedString(this.datasourceResults)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

