/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import com.trulioo.normalizedapi.model.BusinessRecord;
import com.trulioo.normalizedapi.model.ServiceError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="")
public class BusinessSearchResponse {
    @SerializedName(value="TransactionID")
    private String transactionID = null;
    @SerializedName(value="UploadedDt")
    private DateTime uploadedDt = null;
    @SerializedName(value="CountryCode")
    private String countryCode = null;
    @SerializedName(value="ProductName")
    private String productName = null;
    @SerializedName(value="Record")
    private BusinessRecord record = null;
    @SerializedName(value="Errors")
    private List<ServiceError> errors = null;

    public BusinessSearchResponse transactionID(String transactionID) {
        this.transactionID = transactionID;
        return this;
    }

    @ApiModelProperty(value="The id for the transaction it will be a GUID")
    public String getTransactionID() {
        return this.transactionID;
    }

    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    public BusinessSearchResponse uploadedDt(DateTime uploadedDt) {
        this.uploadedDt = uploadedDt;
        return this;
    }

    @ApiModelProperty(value="Time in UTC")
    public DateTime getUploadedDt() {
        return this.uploadedDt;
    }

    public void setUploadedDt(DateTime uploadedDt) {
        this.uploadedDt = uploadedDt;
    }

    public BusinessSearchResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The country code for which the verification was performed.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BusinessSearchResponse productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(value="Product Name")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BusinessSearchResponse record(BusinessRecord record) {
        this.record = record;
        return this;
    }

    @ApiModelProperty(value="")
    public BusinessRecord getRecord() {
        return this.record;
    }

    public void setRecord(BusinessRecord record) {
        this.record = record;
    }

    public BusinessSearchResponse errors(List<ServiceError> errors) {
        this.errors = errors;
        return this;
    }

    public BusinessSearchResponse addErrorsItem(ServiceError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ServiceError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Collection of record errors")
    public List<ServiceError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ServiceError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessSearchResponse businessSearchResponse = (BusinessSearchResponse)o;
        return Objects.equals(this.transactionID, businessSearchResponse.transactionID) && Objects.equals(this.uploadedDt, businessSearchResponse.uploadedDt) && Objects.equals(this.countryCode, businessSearchResponse.countryCode) && Objects.equals(this.productName, businessSearchResponse.productName) && Objects.equals(this.record, businessSearchResponse.record) && Objects.equals(this.errors, businessSearchResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.transactionID, this.uploadedDt, this.countryCode, this.productName, this.record, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessSearchResponse {\n");
        sb.append("    transactionID: ").append(this.toIndentedString(this.transactionID)).append("\n");
        sb.append("    uploadedDt: ").append(this.toIndentedString(this.uploadedDt)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    record: ").append(this.toIndentedString(this.record)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

