/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Consents required from datasource")
public class Consent {
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Text")
    private String text = null;
    @SerializedName(value="Url")
    private String url = null;

    public Consent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the datasource requiring consent")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Consent text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Text outlining how the user is consenting for their data to be used")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Consent url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL where the user can find more information about how the datasource will use their data")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Consent consent = (Consent)o;
        return Objects.equals(this.name, consent.name) && Objects.equals(this.text, consent.text) && Objects.equals(this.url, consent.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.text, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Consent {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

