/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="Transaction Status")
public class TransactionStatus {
    @SerializedName(value="TransactionId")
    private String transactionId = null;
    @SerializedName(value="TransactionRecordId")
    private String transactionRecordId = null;
    @SerializedName(value="Status")
    private String status = null;
    @SerializedName(value="UploadedDt")
    private DateTime uploadedDt = null;
    @SerializedName(value="IsTimedOut")
    private Boolean isTimedOut = null;

    public TransactionStatus transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="Transaction ID of the transaction")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionStatus transactionRecordId(String transactionRecordId) {
        this.transactionRecordId = transactionRecordId;
        return this;
    }

    @ApiModelProperty(value="Transaction Record ID of the transaction available once the transaction has finished processing")
    public String getTransactionRecordId() {
        return this.transactionRecordId;
    }

    public void setTransactionRecordId(String transactionRecordId) {
        this.transactionRecordId = transactionRecordId;
    }

    public TransactionStatus status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the transaction. Possible Values: Uploading, Processing, Completed, InProgress, Failed, WaitAsync, ToBeResumed, Canceled, TimeoutCanceled. Call GetTransactionRecord when status changes to Completed, Failed, Canceled or TimeoutCanceled to get the verification results.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionStatus uploadedDt(DateTime uploadedDt) {
        this.uploadedDt = uploadedDt;
        return this;
    }

    @ApiModelProperty(value="Uploaded date for transaction")
    public DateTime getUploadedDt() {
        return this.uploadedDt;
    }

    public void setUploadedDt(DateTime uploadedDt) {
        this.uploadedDt = uploadedDt;
    }

    public TransactionStatus isTimedOut(Boolean isTimedOut) {
        this.isTimedOut = isTimedOut;
        return this;
    }

    @ApiModelProperty(value="Set to true when transaction has timed out")
    public Boolean getIsTimedOut() {
        return this.isTimedOut;
    }

    public void setIsTimedOut(Boolean isTimedOut) {
        this.isTimedOut = isTimedOut;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionStatus transactionStatus = (TransactionStatus)o;
        return Objects.equals(this.transactionId, transactionStatus.transactionId) && Objects.equals(this.transactionRecordId, transactionStatus.transactionRecordId) && Objects.equals(this.status, transactionStatus.status) && Objects.equals(this.uploadedDt, transactionStatus.uploadedDt) && Objects.equals(this.isTimedOut, transactionStatus.isTimedOut);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.transactionRecordId, this.status, this.uploadedDt, this.isTimedOut);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionStatus {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionRecordId: ").append(this.toIndentedString(this.transactionRecordId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    uploadedDt: ").append(this.toIndentedString(this.uploadedDt)).append("\n");
        sb.append("    isTimedOut: ").append(this.toIndentedString(this.isTimedOut)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

