/*
 * Decompiled with CFR 0.152.
 */
package com.trulioo.normalizedapi.model;

import com.google.gson.annotations.SerializedName;
import com.trulioo.normalizedapi.model.DataFields;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The verification call for the Normalized API is a POST method call")
public class VerifyRequest {
    @SerializedName(value="AcceptTruliooTermsAndConditions")
    private Boolean acceptTruliooTermsAndConditions = null;
    @SerializedName(value="Demo")
    private Boolean demo = null;
    @SerializedName(value="CallBackUrl")
    private String callBackUrl = null;
    @SerializedName(value="Timeout")
    private Integer timeout = null;
    @SerializedName(value="CleansedAddress")
    private Boolean cleansedAddress = null;
    @SerializedName(value="ConfigurationName")
    private String configurationName = null;
    @SerializedName(value="ConsentForDataSources")
    private List<String> consentForDataSources = null;
    @SerializedName(value="CountryCode")
    private String countryCode = null;
    @SerializedName(value="CustomerReferenceID")
    private String customerReferenceID = null;
    @SerializedName(value="DataFields")
    private DataFields dataFields = null;
    @SerializedName(value="VerboseMode")
    private Boolean verboseMode = null;

    public VerifyRequest acceptTruliooTermsAndConditions(Boolean acceptTruliooTermsAndConditions) {
        this.acceptTruliooTermsAndConditions = acceptTruliooTermsAndConditions;
        return this;
    }

    @ApiModelProperty(value="Indicate that Trulioo terms and conditions are accepted")
    public Boolean getAcceptTruliooTermsAndConditions() {
        return this.acceptTruliooTermsAndConditions;
    }

    public void setAcceptTruliooTermsAndConditions(Boolean acceptTruliooTermsAndConditions) {
        this.acceptTruliooTermsAndConditions = acceptTruliooTermsAndConditions;
    }

    public VerifyRequest demo(Boolean demo) {
        this.demo = demo;
        return this;
    }

    @ApiModelProperty(value="This field is not used anymore.  If provided it must match the setting on your account or you will get an error.")
    public Boolean getDemo() {
        return this.demo;
    }

    public void setDemo(Boolean demo) {
        this.demo = demo;
    }

    public VerifyRequest callBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }

    public VerifyRequest timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public VerifyRequest cleansedAddress(Boolean cleansedAddress) {
        this.cleansedAddress = cleansedAddress;
        return this;
    }

    @ApiModelProperty(value="Set to true if you want to receive address cleanse information,  This will only change the response if you have address cleansing enabled for the country you are querying for.")
    public Boolean getCleansedAddress() {
        return this.cleansedAddress;
    }

    public void setCleansedAddress(Boolean cleansedAddress) {
        this.cleansedAddress = cleansedAddress;
    }

    public VerifyRequest configurationName(String configurationName) {
        this.configurationName = configurationName;
        return this;
    }

    @ApiModelProperty(value="Indicate the configuration used for the verification. Currently only  'Identity Verification' is supported.")
    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public VerifyRequest consentForDataSources(List<String> consentForDataSources) {
        this.consentForDataSources = consentForDataSources;
        return this;
    }

    public VerifyRequest addConsentForDataSourcesItem(String consentForDataSourcesItem) {
        if (this.consentForDataSources == null) {
            this.consentForDataSources = new ArrayList<String>();
        }
        this.consentForDataSources.add(consentForDataSourcesItem);
        return this;
    }

    @ApiModelProperty(value="Some datasources required your customer provide consent to access them.  Set that the customer has provided consent for each  datasource that requires one.  If consent is not provided the datasource will not be queried.")
    public List<String> getConsentForDataSources() {
        return this.consentForDataSources;
    }

    public void setConsentForDataSources(List<String> consentForDataSources) {
        this.consentForDataSources = consentForDataSources;
    }

    public VerifyRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The country code for which the verification needs to be performed.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public VerifyRequest customerReferenceID(String customerReferenceID) {
        this.customerReferenceID = customerReferenceID;
        return this;
    }

    @ApiModelProperty(value="Customer Reference Id")
    public String getCustomerReferenceID() {
        return this.customerReferenceID;
    }

    public void setCustomerReferenceID(String customerReferenceID) {
        this.customerReferenceID = customerReferenceID;
    }

    public VerifyRequest dataFields(DataFields dataFields) {
        this.dataFields = dataFields;
        return this;
    }

    @ApiModelProperty(required=true, value="The data field name-value pairs for the data elements on which the verification is to be performed")
    public DataFields getDataFields() {
        return this.dataFields;
    }

    public void setDataFields(DataFields dataFields) {
        this.dataFields = dataFields;
    }

    public VerifyRequest verboseMode(Boolean verboseMode) {
        this.verboseMode = verboseMode;
        return this;
    }

    @ApiModelProperty(value="Verbose Mode Output Flag.")
    public Boolean getVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(Boolean verboseMode) {
        this.verboseMode = verboseMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyRequest verifyRequest = (VerifyRequest)o;
        return Objects.equals(this.acceptTruliooTermsAndConditions, verifyRequest.acceptTruliooTermsAndConditions) && Objects.equals(this.demo, verifyRequest.demo) && Objects.equals(this.callBackUrl, verifyRequest.callBackUrl) && Objects.equals(this.timeout, verifyRequest.timeout) && Objects.equals(this.cleansedAddress, verifyRequest.cleansedAddress) && Objects.equals(this.configurationName, verifyRequest.configurationName) && Objects.equals(this.consentForDataSources, verifyRequest.consentForDataSources) && Objects.equals(this.countryCode, verifyRequest.countryCode) && Objects.equals(this.customerReferenceID, verifyRequest.customerReferenceID) && Objects.equals(this.dataFields, verifyRequest.dataFields) && Objects.equals(this.verboseMode, verifyRequest.verboseMode);
    }

    public int hashCode() {
        return Objects.hash(this.acceptTruliooTermsAndConditions, this.demo, this.callBackUrl, this.timeout, this.cleansedAddress, this.configurationName, this.consentForDataSources, this.countryCode, this.customerReferenceID, this.dataFields, this.verboseMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerifyRequest {\n");
        sb.append("    acceptTruliooTermsAndConditions: ").append(this.toIndentedString(this.acceptTruliooTermsAndConditions)).append("\n");
        sb.append("    demo: ").append(this.toIndentedString(this.demo)).append("\n");
        sb.append("    callBackUrl: ").append(this.toIndentedString(this.callBackUrl)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    cleansedAddress: ").append(this.toIndentedString(this.cleansedAddress)).append("\n");
        sb.append("    configurationName: ").append(this.toIndentedString(this.configurationName)).append("\n");
        sb.append("    consentForDataSources: ").append(this.toIndentedString(this.consentForDataSources)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    customerReferenceID: ").append(this.toIndentedString(this.customerReferenceID)).append("\n");
        sb.append("    dataFields: ").append(this.toIndentedString(this.dataFields)).append("\n");
        sb.append("    verboseMode: ").append(this.toIndentedString(this.verboseMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

