/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos;

import feign.RequestInterceptor;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.MarathonClient;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncher;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.mesos.constraints.ConstraintConverter;
import org.springframework.cloud.deployer.spi.mesos.dcos.DcosClusterProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployer;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.mesos.chronos.client.Chronos;
import org.springframework.cloud.mesos.chronos.client.ChronosClient;
import org.springframework.cloud.mesos.dcos.client.DcosHeadersInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={MarathonAppDeployerProperties.class, ChronosTaskLauncherProperties.class, DcosClusterProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class MesosAutoConfiguration {
    @Bean
    @RefreshScope
    public Marathon marathon(MarathonAppDeployerProperties marathonProperties, DcosClusterProperties dcosClusterProperties) {
        if (StringUtils.hasText((String)dcosClusterProperties.getAuthorizationToken())) {
            return MarathonClient.getInstance((String)marathonProperties.getApiEndpoint(), (RequestInterceptor[])new RequestInterceptor[]{new DcosHeadersInterceptor(dcosClusterProperties.getAuthorizationToken())});
        }
        return MarathonClient.getInstance((String)marathonProperties.getApiEndpoint());
    }

    @Bean
    @RefreshScope
    public AppDeployer appDeployer(MarathonAppDeployerProperties marathonProperties, Marathon marathon) {
        return new MarathonAppDeployer(marathonProperties, marathon);
    }

    @Bean
    @RefreshScope
    public Chronos chronos(ChronosTaskLauncherProperties chronosProperties, DcosClusterProperties dcosClusterProperties) {
        if (StringUtils.hasText((String)dcosClusterProperties.getAuthorizationToken())) {
            return ChronosClient.getInstance(chronosProperties.getApiEndpoint(), new DcosHeadersInterceptor(dcosClusterProperties.getAuthorizationToken()));
        }
        return ChronosClient.getInstance(chronosProperties.getApiEndpoint());
    }

    @Bean
    @RefreshScope
    public TaskLauncher taskDeployer(ChronosTaskLauncherProperties chronosProperties, Chronos chronos) {
        return new ChronosTaskLauncher(chronosProperties, chronos);
    }

    @Bean
    @ConfigurationPropertiesBinding
    public ConstraintConverter constraintConverter() {
        return new ConstraintConverter();
    }
}

