/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos.marathon;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.model.v2.HealthCheckResults;
import mesosphere.marathon.client.model.v2.Task;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MarathonAppInstanceStatus
implements AppInstanceStatus {
    private final App app;
    private final Task task;

    private MarathonAppInstanceStatus(App app, Task task) {
        this.app = app;
        this.task = task;
    }

    static MarathonAppInstanceStatus up(App app, Task task) {
        return new MarathonAppInstanceStatus(app, task);
    }

    static MarathonAppInstanceStatus down(App app) {
        return new MarathonAppInstanceStatus(app, null);
    }

    public String getId() {
        return this.task != null ? this.task.getId() : this.app.getId() + "-failed-" + new Random().nextInt();
    }

    public DeploymentState getState() {
        boolean alive;
        if (this.task == null) {
            if (this.app.getLastTaskFailure() == null) {
                return DeploymentState.unknown;
            }
            return DeploymentState.failed;
        }
        if (this.app.getInstances() > this.app.getTasksRunning()) {
            return DeploymentState.deploying;
        }
        Collection healthCheckResults = this.task.getHealthCheckResults();
        boolean bl = alive = !CollectionUtils.isEmpty((Collection)healthCheckResults) && ((HealthCheckResults)healthCheckResults.iterator().next()).getAlive() != false;
        if (!alive && this.app.getLastTaskFailure() != null) {
            return DeploymentState.failed;
        }
        return alive ? DeploymentState.deployed : DeploymentState.deploying;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.task != null) {
            result.put("staged_at", this.task.getStagedAt());
            result.put("started_at", this.task.getStartedAt());
            result.put("host", this.task.getHost());
            result.put("ports", StringUtils.collectionToCommaDelimitedString((Collection)this.task.getPorts()));
        }
        return result;
    }
}

