/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.mesos.chronos.client;

import feign.Feign;
import feign.FeignException;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.cloud.mesos.chronos.client.Chronos;
import org.springframework.cloud.mesos.chronos.client.ChronosException;
import org.springframework.cloud.mesos.chronos.client.model.AbstractModel;
import org.springframework.util.MimeTypeUtils;

public class ChronosClient {
    public static Chronos getInstance(String endpoint) {
        return ChronosClient.getInstance(endpoint, null);
    }

    public static Chronos getInstance(String endpoint, RequestInterceptor ... interceptors) {
        Feign.Builder b = Feign.builder().encoder((Encoder)new GsonEncoder(AbstractModel.GSON)).decoder((Decoder)new MultiDecoder()).errorDecoder((ErrorDecoder)new ChronosErrorDecoder());
        if (interceptors != null) {
            b.requestInterceptors(Arrays.asList(interceptors));
        }
        b.requestInterceptor((RequestInterceptor)new ChronosHeadersInterceptor());
        return (Chronos)b.target(Chronos.class, endpoint);
    }

    public static Chronos getInstanceWithBasicAuth(String endpoint, String username, String password) {
        return ChronosClient.getInstance(endpoint, new RequestInterceptor[]{new BasicAuthRequestInterceptor(username, password)});
    }

    public static class MultiDecoder
    implements Decoder {
        GsonDecoder gsonDecoder = new GsonDecoder(AbstractModel.GSON);
        Decoder defaultDecoder = new Decoder.Default();

        public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
            Collection contentTypes = (Collection)response.headers().get("Content-Type");
            if (contentTypes.contains(MimeTypeUtils.TEXT_PLAIN.toString())) {
                return this.defaultDecoder.decode(response, type);
            }
            return this.gsonDecoder.decode(response, type);
        }
    }

    static class ChronosErrorDecoder
    implements ErrorDecoder {
        ChronosErrorDecoder() {
        }

        public Exception decode(String methodKey, Response response) {
            return new ChronosException(response.status(), response.reason());
        }
    }

    static class ChronosHeadersInterceptor
    implements RequestInterceptor {
        ChronosHeadersInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("Content-Type", new String[]{"application/json"});
        }
    }
}

