/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.client;

import com.trustly.api.domain.exceptions.TrustlyValidationException;
import com.trustly.api.validation.AnnotationsValidator;
import com.trustly.api.validation.AnnotationsValidatorLoader;
import com.trustly.api.validation.HibernateDataAnnotationsValidatorLoader;
import com.trustly.api.validation.ValidationResult;
import java.util.List;

public class JsonRpcValidator {
    private static final AnnotationsValidatorLoader[] ANNOTATIONS_VALIDATORS = new AnnotationsValidatorLoader[]{new HibernateDataAnnotationsValidatorLoader()};
    private final AnnotationsValidator validator;

    public JsonRpcValidator() {
        AnnotationsValidatorLoader loader;
        AnnotationsValidator foundValidator = null;
        AnnotationsValidatorLoader[] annotationsValidatorLoaderArray = ANNOTATIONS_VALIDATORS;
        int n = annotationsValidatorLoaderArray.length;
        for (int i = 0; i < n && (foundValidator = (loader = annotationsValidatorLoaderArray[i]).create()) == null; ++i) {
        }
        this.validator = foundValidator;
    }

    public void validate(Object jsonRpcRequest) throws TrustlyValidationException {
        if (this.validator == null) {
            return;
        }
        List<ValidationResult> results = this.validator.validate(jsonRpcRequest);
        if (!results.isEmpty()) {
            CharSequence[] messages = (String[])results.stream().map(ValidationResult::getErrorMessage).toArray(String[]::new);
            throw new TrustlyValidationException(String.join((CharSequence)", ", messages));
        }
    }
}

