/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.client;

import com.trustly.api.domain.base.IRequestParamsData;
import com.trustly.api.domain.exceptions.TrustlyValidationException;
import jakarta.validation.Valid;
import java.io.IOException;

public class NotificationArgs<D extends IRequestParamsData> {
    @Valid
    private final D data;
    private final String method;
    private final String uuid;
    private final NotificationOkHandler onOK;
    private final NotificationFailHandler onFailed;

    public void respondWithOk() throws TrustlyValidationException, IOException {
        this.onOK.handle(this.method, this.uuid);
    }

    public void respondWithFailed(String message) throws TrustlyValidationException, IOException {
        this.onFailed.handle(this.method, this.uuid, message);
    }

    public NotificationArgs(D data, String method, String uuid, NotificationOkHandler onOK, NotificationFailHandler onFailed) {
        this.data = data;
        this.method = method;
        this.uuid = uuid;
        this.onOK = onOK;
        this.onFailed = onFailed;
    }

    public D getData() {
        return this.data;
    }

    @FunctionalInterface
    public static interface NotificationFailHandler {
        public void handle(String var1, String var2, String var3) throws IOException, TrustlyValidationException;
    }

    @FunctionalInterface
    public static interface NotificationOkHandler {
        public void handle(String var1, String var2) throws IOException, TrustlyValidationException;
    }
}

