/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trustly.api.client.DefaultJsonRpcSigner;
import com.trustly.api.client.JsonRpcFactory;
import com.trustly.api.client.JsonRpcSigner;
import com.trustly.api.client.JsonRpcValidator;
import com.trustly.api.client.NotificationArgs;
import com.trustly.api.client.NotificationEvent;
import com.trustly.api.client.Serializer;
import com.trustly.api.client.TrustlyApiClientSettings;
import com.trustly.api.domain.base.IData;
import com.trustly.api.domain.base.IFromTrustlyRequestData;
import com.trustly.api.domain.base.IRequestParamsData;
import com.trustly.api.domain.base.IResponseResultData;
import com.trustly.api.domain.base.IToTrustlyRequestParams;
import com.trustly.api.domain.base.IWithRejectionResult;
import com.trustly.api.domain.base.JsonRpcRequest;
import com.trustly.api.domain.base.JsonRpcResponse;
import com.trustly.api.domain.base.NotificationRequest;
import com.trustly.api.domain.base.NotificationRequestParams;
import com.trustly.api.domain.base.ResponseResult;
import com.trustly.api.domain.exceptions.TrustlyErrorResponseException;
import com.trustly.api.domain.exceptions.TrustlyNoNotificationListenerException;
import com.trustly.api.domain.exceptions.TrustlyRejectionException;
import com.trustly.api.domain.exceptions.TrustlyRequestException;
import com.trustly.api.domain.exceptions.TrustlySignatureException;
import com.trustly.api.domain.exceptions.TrustlyValidationException;
import com.trustly.api.domain.methods.accountledger.AccountLedgerRequestData;
import com.trustly.api.domain.methods.accountledger.AccountLedgerResponseData;
import com.trustly.api.domain.methods.accountpayout.AccountPayoutRequestData;
import com.trustly.api.domain.methods.accountpayout.AccountPayoutResponseData;
import com.trustly.api.domain.methods.approvewithdrawal.ApproveWithdrawalRequestData;
import com.trustly.api.domain.methods.approvewithdrawal.ApproveWithdrawalResponseData;
import com.trustly.api.domain.methods.balance.BalanceRequestData;
import com.trustly.api.domain.methods.balance.BalanceResponseData;
import com.trustly.api.domain.methods.cancelcharge.CancelChargeRequestData;
import com.trustly.api.domain.methods.cancelcharge.CancelChargeResponseData;
import com.trustly.api.domain.methods.charge.ChargeRequestData;
import com.trustly.api.domain.methods.charge.ChargeResponseData;
import com.trustly.api.domain.methods.createaccount.CreateAccountRequestData;
import com.trustly.api.domain.methods.createaccount.CreateAccountResponseData;
import com.trustly.api.domain.methods.denywithdrawal.DenyWithdrawalRequestData;
import com.trustly.api.domain.methods.denywithdrawal.DenyWithdrawalResponseData;
import com.trustly.api.domain.methods.deposit.DepositRequestData;
import com.trustly.api.domain.methods.deposit.DepositResponseData;
import com.trustly.api.domain.methods.getwithdrawals.GetWithdrawalsRequestData;
import com.trustly.api.domain.methods.getwithdrawals.GetWithdrawalsResponseData;
import com.trustly.api.domain.methods.merchantsettlement.MerchantSettlementRequestData;
import com.trustly.api.domain.methods.merchantsettlement.MerchantSettlementResponseData;
import com.trustly.api.domain.methods.refund.RefundRequestData;
import com.trustly.api.domain.methods.refund.RefundResponseData;
import com.trustly.api.domain.methods.registeraccount.RegisterAccountRequestData;
import com.trustly.api.domain.methods.registeraccount.RegisterAccountResponseData;
import com.trustly.api.domain.methods.registeraccountpayout.RegisterAccountPayoutRequestData;
import com.trustly.api.domain.methods.registeraccountpayout.RegisterAccountPayoutResponseData;
import com.trustly.api.domain.methods.selectaccount.SelectAccountRequestData;
import com.trustly.api.domain.methods.selectaccount.SelectAccountResponseData;
import com.trustly.api.domain.methods.settlementreport.SettlementReportRequestData;
import com.trustly.api.domain.methods.settlementreport.SettlementReportResponseData;
import com.trustly.api.domain.methods.withdraw.WithdrawRequestData;
import com.trustly.api.domain.methods.withdraw.WithdrawResponseData;
import com.trustly.api.domain.notifications.AccountNotificationData;
import com.trustly.api.domain.notifications.CancelNotificationData;
import com.trustly.api.domain.notifications.CreditNotificationData;
import com.trustly.api.domain.notifications.DebitNotificationData;
import com.trustly.api.domain.notifications.PayoutConfirmationNotificationData;
import com.trustly.api.domain.notifications.PendingNotificationData;
import com.trustly.api.domain.notifications.UnknownNotificationData;
import com.trustly.api.request.ApacheHttpClient3HttpRequesterLoader;
import com.trustly.api.request.ApacheHttpClient4HttpRequesterLoader;
import com.trustly.api.request.ApacheHttpClient5HttpRequesterLoader;
import com.trustly.api.request.HttpRequester;
import com.trustly.api.request.HttpRequesterLoader;
import com.trustly.api.request.JavaUrlConnectionHttpRequesterLoader;
import com.trustly.api.util.TrustlyStringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustlyApiClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TrustlyApiClient.class);
    private static final List<TrustlyApiClient> STATIC_REGISTERED_CLIENTS = new ArrayList<TrustlyApiClient>();
    private static final HttpRequesterLoader[] AVAILABLE_HTTP_REQUESTERS = new HttpRequesterLoader[]{new ApacheHttpClient5HttpRequesterLoader(), new ApacheHttpClient4HttpRequesterLoader(), new ApacheHttpClient3HttpRequesterLoader(), new JavaUrlConnectionHttpRequesterLoader()};
    private final TrustlyApiClientSettings settings;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonRpcFactory objectFactory = new JsonRpcFactory();
    private final JsonRpcSigner signer;
    private final JsonRpcValidator validator = new JsonRpcValidator();
    private final HttpRequester httpRequester;
    private final Map<String, NotificationMeta<? extends IFromTrustlyRequestData>> onNotification = new HashMap<String, NotificationMeta<? extends IFromTrustlyRequestData>>();

    private static HttpRequester getFirstAvailableHttpRequester() {
        HttpRequesterLoader loader;
        HttpRequester foundHttpRequester = null;
        HttpRequesterLoader[] httpRequesterLoaderArray = AVAILABLE_HTTP_REQUESTERS;
        int n = httpRequesterLoaderArray.length;
        for (int i = 0; i < n && (foundHttpRequester = (loader = httpRequesterLoaderArray[i]).create()) == null; ++i) {
        }
        if (foundHttpRequester == null) {
            throw new IllegalStateException("Could not find a suitable http requester factory");
        }
        return foundHttpRequester;
    }

    public TrustlyApiClientSettings getSettings() {
        return this.settings;
    }

    public TrustlyApiClient(TrustlyApiClientSettings settings) {
        this(settings, new DefaultJsonRpcSigner(new Serializer(), settings), TrustlyApiClient.getFirstAvailableHttpRequester());
    }

    public TrustlyApiClient(TrustlyApiClientSettings settings, JsonRpcSigner signer) {
        this(settings, signer, TrustlyApiClient.getFirstAvailableHttpRequester());
    }

    public TrustlyApiClient(TrustlyApiClientSettings settings, HttpRequester httpRequester) {
        this(settings, new DefaultJsonRpcSigner(new Serializer(), settings), httpRequester);
    }

    public TrustlyApiClient(TrustlyApiClientSettings settings, JsonRpcSigner signer, HttpRequester httpRequester) {
        this.settings = settings;
        this.signer = signer;
        this.httpRequester = httpRequester;
        STATIC_REGISTERED_CLIENTS.add(this);
    }

    @Override
    public void close() {
        STATIC_REGISTERED_CLIENTS.remove(this);
    }

    public static Iterable<TrustlyApiClient> getRegisteredClients() {
        return STATIC_REGISTERED_CLIENTS;
    }

    public AccountLedgerResponseData accountLedger(AccountLedgerRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, AccountLedgerResponseData.class, "AccountLedger", null);
    }

    public AccountPayoutResponseData accountPayout(AccountPayoutRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, AccountPayoutResponseData.class, "AccountPayout", null);
    }

    public ApproveWithdrawalResponseData approveWithdrawal(ApproveWithdrawalRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, ApproveWithdrawalResponseData.class, "ApproveWithdrawal", null);
    }

    public BalanceResponseData balance(BalanceRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, BalanceResponseData.class, "Balance", null);
    }

    public CancelChargeResponseData cancelCharge(CancelChargeRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, CancelChargeResponseData.class, "CancelCharge", null);
    }

    public ChargeResponseData charge(ChargeRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, ChargeResponseData.class, "Charge", null);
    }

    public DenyWithdrawalResponseData denyWithdrawal(DenyWithdrawalRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, DenyWithdrawalResponseData.class, "DenyWithdrawal", null);
    }

    public DepositResponseData deposit(DepositRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, DepositResponseData.class, "Deposit", null);
    }

    public GetWithdrawalsResponseData getWithdrawals(GetWithdrawalsRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, GetWithdrawalsResponseData.class, "GetWithdrawals", null);
    }

    public RefundResponseData refund(RefundRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, RefundResponseData.class, "Refund", null);
    }

    public CreateAccountResponseData createAccount(CreateAccountRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, CreateAccountResponseData.class, "CreateAccount", null);
    }

    public SelectAccountResponseData selectAccount(SelectAccountRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, SelectAccountResponseData.class, "SelectAccount", null);
    }

    public RegisterAccountResponseData registerAccount(RegisterAccountRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, RegisterAccountResponseData.class, "RegisterAccount", null);
    }

    public RegisterAccountPayoutResponseData registerAccountPayout(RegisterAccountPayoutRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, RegisterAccountPayoutResponseData.class, "RegisterAccountPayout", null);
    }

    public MerchantSettlementResponseData registerMerchantSettlement(MerchantSettlementRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, MerchantSettlementResponseData.class, "MerchantSettlement", null);
    }

    public SettlementReportResponseData settlementReport(SettlementReportRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, SettlementReportResponseData.class, "ViewAutomaticSettlementDetailsCSV", null);
    }

    public WithdrawResponseData withdraw(WithdrawRequestData request) throws TrustlyRequestException {
        return this.sendRequest(request, WithdrawResponseData.class, "Withdraw", null);
    }

    public <D extends IFromTrustlyRequestData> void addNotificationListener(String method, Class<D> dataClass, NotificationEvent<D> listener) {
        NotificationMeta meta = this.onNotification.computeIfAbsent(method, k -> new NotificationMeta(dataClass));
        if (!meta.getDataClass().equals(dataClass)) {
            throw new IllegalArgumentException(String.format("Each notification method must be registered with the same type (%s vs %s)", dataClass, meta.getDataClass()));
        }
        meta.getListeners().add(listener);
    }

    public void addOnAccountListener(NotificationEvent<AccountNotificationData> listener) {
        this.addNotificationListener("account", AccountNotificationData.class, listener);
    }

    public void addOnCancelListener(NotificationEvent<CancelNotificationData> listener) {
        this.addNotificationListener("cancel", CancelNotificationData.class, listener);
    }

    public void addOnCreditListener(NotificationEvent<CreditNotificationData> listener) {
        this.addNotificationListener("credit", CreditNotificationData.class, listener);
    }

    public void addOnDebitListener(NotificationEvent<DebitNotificationData> listener) {
        this.addNotificationListener("debit", DebitNotificationData.class, listener);
    }

    public void addOnPayoutConfirmation(NotificationEvent<PayoutConfirmationNotificationData> listener) {
        this.addNotificationListener("payoutconfirmation", PayoutConfirmationNotificationData.class, listener);
    }

    public void addOnPending(NotificationEvent<PendingNotificationData> listener) {
        this.addNotificationListener("pending", PendingNotificationData.class, listener);
    }

    public void addOnUnknownNotification(NotificationEvent<UnknownNotificationData> listener) {
        this.addNotificationListener("", UnknownNotificationData.class, listener);
    }

    public <T extends IRequestParamsData> JsonRpcRequest<T> createRequestPackage(T requestData, String method, String uuid) throws TrustlyValidationException {
        JsonRpcRequest<T> rpcRequest = this.objectFactory.create(requestData, method, uuid);
        JsonRpcRequest<T> signedRpcRequest = this.signer.sign(rpcRequest);
        this.validator.validate(signedRpcRequest);
        return signedRpcRequest;
    }

    public <R extends IResponseResultData> JsonRpcResponse<R> createResponsePackage(String method, String uuid, R responseData) throws TrustlyValidationException {
        JsonRpcResponse rpcResponse = JsonRpcResponse.builder().version("1.1").result(ResponseResult.builder().data(responseData).method(method).uuid(uuid).build()).build();
        JsonRpcResponse signedResponse = this.signer.sign(rpcResponse);
        this.validator.validate(signedResponse);
        return signedResponse;
    }

    public <T extends IToTrustlyRequestParams, R extends IResponseResultData> R sendRequest(T requestData, Class<R> clazz, String method, String uuid) throws TrustlyRequestException {
        try {
            return this.sendRequestWithSpecificExceptions(requestData, clazz, method, uuid);
        }
        catch (TrustlyErrorResponseException | TrustlyRejectionException | TrustlySignatureException | TrustlyValidationException | IOException e) {
            throw new TrustlyRequestException(e);
        }
    }

    private <T extends IToTrustlyRequestParams, R extends IResponseResultData> R sendRequestWithSpecificExceptions(T requestData, Class<R> clazz, String method, String uuid) throws TrustlyErrorResponseException, IOException, TrustlyRejectionException, TrustlySignatureException, TrustlyValidationException {
        requestData.setUsername(this.settings.getUsername());
        requestData.setPassword(this.settings.getPassword());
        JsonRpcRequest<T> rpcRequest = this.createRequestPackage(requestData, method, uuid);
        String requestString = this.objectMapper.writeValueAsString(rpcRequest);
        String responseString = this.httpRequester.request(this.settings, requestString);
        JsonNode rpcNodeResponse = this.objectMapper.readTree(responseString);
        JavaType javaResponseType = this.objectMapper.getTypeFactory().constructParametricType(JsonRpcResponse.class, new Class[]{clazz});
        JsonRpcResponse rpcResponse = (JsonRpcResponse)this.objectMapper.readValue(responseString, javaResponseType);
        TrustlyApiClient.assertSuccessful(rpcResponse);
        TrustlyApiClient.assertWithoutRejection(rpcResponse);
        this.signer.verify(rpcResponse, rpcNodeResponse);
        if (TrustlyStringUtils.isBlank(rpcResponse.getUUID()) || !rpcResponse.getUUID().equals(rpcRequest.getParams().getUuid())) {
            throw new TrustlyValidationException(String.format("Incoming UUID is not valid. Expected %s but got back %s", rpcRequest.getParams().getUuid(), rpcResponse.getUUID()));
        }
        return (R)rpcResponse.getResult().getData();
    }

    private static <R extends IResponseResultData> void assertWithoutRejection(JsonRpcResponse<R> rpcResponse) throws TrustlyRejectionException {
        IWithRejectionResult rejectionResult;
        if (rpcResponse.getResult().getData() instanceof IWithRejectionResult && !(rejectionResult = (IWithRejectionResult)rpcResponse.getResult().getData()).isResult()) {
            String message = rejectionResult.getRejected();
            if (TrustlyStringUtils.isBlank(message)) {
                message = "The request was rejected for an unknown reason";
            }
            throw new TrustlyRejectionException("Received a rejection response from the Trustly API: " + message, rejectionResult.getRejected());
        }
    }

    private static <R extends IResponseResultData> void assertSuccessful(JsonRpcResponse<R> rpcResponse) throws TrustlyErrorResponseException {
        if (!rpcResponse.isSuccessfulResult()) {
            String message = null;
            if (rpcResponse.getError() != null && TrustlyStringUtils.isBlank(message = rpcResponse.getError().getMessage()) && TrustlyStringUtils.isBlank(message = rpcResponse.getError().getName())) {
                message = "" + rpcResponse.getError().getCode();
            }
            throw new TrustlyErrorResponseException(String.format("Received an error response from the Trustly API: %s", message), null, rpcResponse.getError());
        }
    }

    public void handleNotification(String jsonString, NotificationArgs.NotificationOkHandler onOK, NotificationArgs.NotificationFailHandler onFailed) throws IOException, TrustlyNoNotificationListenerException, TrustlyValidationException, TrustlySignatureException {
        JsonNode jsonToken = this.objectMapper.readTree(jsonString);
        String methodValue = jsonToken.at("/method").asText("").toLowerCase(Locale.ROOT);
        NotificationMeta<? extends IFromTrustlyRequestData> mapper = this.onNotification.get(methodValue);
        if (mapper == null || mapper.getListeners().isEmpty()) {
            log.warn(String.format("There is no listener for incoming notification '%s'. Will fallback on 'unknown' listener", methodValue));
            mapper = this.onNotification.get("");
            if (mapper == null || mapper.getListeners().isEmpty()) {
                throw new TrustlyNoNotificationListenerException(String.format("There is no listener for incoming notification '%s' nor unknown", methodValue));
            }
        }
        this.handleNotification(jsonString, mapper, onOK, onFailed);
    }

    private <D extends IFromTrustlyRequestData> void handleNotification(String jsonString, NotificationMeta<D> meta, NotificationArgs.NotificationOkHandler onOK, NotificationArgs.NotificationFailHandler onFailed) throws IOException, TrustlyValidationException, TrustlySignatureException {
        JavaType javaRequestType = this.objectMapper.getTypeFactory().constructParametricType(NotificationRequest.class, new Class[]{meta.getDataClass()});
        NotificationRequest rpcRequest = (NotificationRequest)this.objectMapper.readValue(jsonString, javaRequestType);
        try {
            this.signer.verify(rpcRequest);
        }
        catch (TrustlySignatureException ex) {
            throw new TrustlySignatureException("Could not validate signature of notification from Trustly. Is the public key for Trustly the correct one, for test or production?", ex);
        }
        this.validator.validate(rpcRequest);
        NotificationArgs<IData> args = new NotificationArgs<IData>(((NotificationRequestParams)rpcRequest.getParams()).getData(), rpcRequest.getMethod(), ((NotificationRequestParams)rpcRequest.getParams()).getUuid(), onOK, onFailed);
        try {
            for (NotificationEvent<IData> notificationEvent : meta.getListeners()) {
                notificationEvent.onNotification(args);
            }
        }
        catch (Exception ex) {
            String string = this.settings.isIncludeExceptionMessageInNotificationResponse() ? ex.getMessage() : null;
            onFailed.handle(rpcRequest.getMethod(), ((NotificationRequestParams)rpcRequest.getParams()).getUuid(), string);
        }
    }

    private static final class NotificationMeta<D extends IFromTrustlyRequestData> {
        private final Class<D> dataClass;
        private final List<NotificationEvent<D>> listeners = new ArrayList<NotificationEvent<D>>();

        public NotificationMeta(Class<D> dataClass) {
            this.dataClass = dataClass;
        }

        public Class<D> getDataClass() {
            return this.dataClass;
        }

        public List<NotificationEvent<D>> getListeners() {
            return this.listeners;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationMeta)) {
                return false;
            }
            NotificationMeta other = (NotificationMeta)o;
            Class<D> this$dataClass = this.getDataClass();
            Class<D> other$dataClass = other.getDataClass();
            if (this$dataClass == null ? other$dataClass != null : !this$dataClass.equals(other$dataClass)) {
                return false;
            }
            List<NotificationEvent<D>> this$listeners = this.getListeners();
            List<NotificationEvent<D>> other$listeners = other.getListeners();
            return !(this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<D> $dataClass = this.getDataClass();
            result = result * 59 + ($dataClass == null ? 43 : $dataClass.hashCode());
            List<NotificationEvent<D>> $listeners = this.getListeners();
            result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
            return result;
        }

        public String toString() {
            return "TrustlyApiClient.NotificationMeta(dataClass=" + this.getDataClass() + ", listeners=" + this.getListeners() + ")";
        }
    }
}

