/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.client;

import com.trustly.api.util.TrustlyFileUtils;
import com.trustly.api.util.TrustlyStringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class TrustlyApiClientSettings {
    static final String URL_TEST = "https://test.trustly.com/api/1";
    static final String URL_PRODUCTION = "https://api.trustly.com/1";
    private String url;
    private String username;
    private String password;
    private PublicKey clientPublicKey;
    private PrivateKey clientPrivateKey;
    private PublicKey trustlyPublicKey;
    private boolean includeMessageInNotificationResponse = true;
    private boolean includeExceptionMessageInNotificationResponse = false;

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public PublicKey getClientPublicKey() {
        return this.clientPublicKey;
    }

    public PrivateKey getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    public PublicKey getTrustlyPublicKey() {
        return this.trustlyPublicKey;
    }

    public boolean isIncludeMessageInNotificationResponse() {
        return this.includeMessageInNotificationResponse;
    }

    public void setIncludeMessageInNotificationResponse(boolean includeMessageInNotificationResponse) {
        this.includeMessageInNotificationResponse = includeMessageInNotificationResponse;
    }

    public boolean isIncludeExceptionMessageInNotificationResponse() {
        return this.includeExceptionMessageInNotificationResponse;
    }

    public void setIncludeExceptionMessageInNotificationResponse(boolean includeExceptionMessageInNotificationResponse) {
        this.includeExceptionMessageInNotificationResponse = includeExceptionMessageInNotificationResponse;
    }

    private TrustlyApiClientSettings() {
    }

    public static TrustlyApiClientSettings forDefaultProduction() {
        return TrustlyApiClientSettings.forDefaultCustom(URL_PRODUCTION, null, null, null, null, null, null, null, null);
    }

    public static TrustlyApiClientSettings forDefaultTest() {
        return TrustlyApiClientSettings.forDefaultCustom(URL_TEST, null, null, null, null, null, null, null, null);
    }

    public static TrustlyApiClientSettings forDefaultCustom(String url, String username, String password, String publicKeyPath, String privateKeyPath, String envUsername, String envPassword, String envCertPublic, String envCertPrivate) {
        boolean hasEnvUsername;
        envUsername = envUsername == null ? "CLIENT_USERNAME" : envUsername;
        envPassword = envPassword == null ? "CLIENT_PASSWORD" : envPassword;
        envCertPublic = envCertPublic == null ? "CLIENT_CERT_PUBLIC" : envCertPublic;
        envCertPrivate = envCertPrivate == null ? "CLIENT_CERT_PRIVATE" : envCertPrivate;
        WithEnvironment settings = new WithEnvironment(new TrustlyApiClientSettings(), url);
        boolean bl = hasEnvUsername = !TrustlyStringUtils.isBlank(System.getenv(envUsername));
        if (hasEnvUsername) {
            return TrustlyApiClientSettings.forTest().withCredentialsFromEnv(envUsername, envPassword).withCertificatesFromEnv(envCertPublic, envCertPrivate).andTrustlyCertificate();
        }
        WithCredentials withCredentials = TrustlyStringUtils.isBlank(username) ? settings.withCredentialsFromUserHome(null, null) : settings.withCredentials(username, password);
        WithClientCertificates withCertificates = TrustlyStringUtils.isBlank(privateKeyPath) ? withCredentials.withCertificatesFromUserHome(null, null) : withCredentials.withCertificatesFromFiles(publicKeyPath, privateKeyPath);
        return withCertificates.andTrustlyCertificate();
    }

    public static WithEnvironment forProduction() {
        return new WithEnvironment(new TrustlyApiClientSettings(), URL_PRODUCTION);
    }

    public static WithEnvironment forTest() {
        return new WithEnvironment(new TrustlyApiClientSettings(), URL_TEST);
    }

    public static WithEnvironment forCustom(String url) {
        if (TrustlyStringUtils.isBlank(url)) {
            throw new IllegalArgumentException("The URL must not be null nor empty");
        }
        return new WithEnvironment(new TrustlyApiClientSettings(), url);
    }

    private static String getUserHome() {
        return System.getProperty("user.home");
    }

    private static PemObject readerToPemObject(InputStream is) throws IOException {
        try (InputStreamReader publicReader = new InputStreamReader(is);){
            PemReader publicPemParser = new PemReader((Reader)publicReader);
            PemObject pemObject = publicPemParser.readPemObject();
            return pemObject;
        }
    }

    private static PublicKey streamToJavaPublicKey(InputStream is, String filename) throws IOException {
        byte[] content;
        if (filename != null && filename.toLowerCase(Locale.ROOT).endsWith(".der")) {
            int numRead;
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((numRead = is.read(buffer, 0, buffer.length)) > 0) {
                baos.write(buffer, 0, numRead);
            }
            content = baos.toByteArray();
        } else {
            PemObject publicObject = TrustlyApiClientSettings.readerToPemObject(is);
            content = publicObject.getContent();
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(content);
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
            return factory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not find the required algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Could not load the public key because of an invalid key spec", e);
        }
        catch (NoSuchProviderException e) {
            throw new IOException("Could not find the BouncyCastle key provider", e);
        }
    }

    private static PrivateKey streamToJavaPrivateKey(InputStream is, String filename) throws IOException {
        byte[] content;
        if (filename != null && filename.toLowerCase(Locale.ROOT).endsWith(".der")) {
            int numRead;
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((numRead = is.read(buffer, 0, buffer.length)) > 0) {
                baos.write(buffer, 0, numRead);
            }
            content = baos.toByteArray();
        } else {
            PemObject publicObject = TrustlyApiClientSettings.readerToPemObject(is);
            content = publicObject.getContent();
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(content);
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
            return factory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not find the required algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Could not load the public key because of an invalid key spec", e);
        }
        catch (NoSuchProviderException e) {
            throw new IOException("Could not find the BouncyCastle key provider", e);
        }
    }

    public static class WithClientCertificates {
        private final TrustlyApiClientSettings settings;

        public WithClientCertificates(TrustlyApiClientSettings settings, PublicKey clientPublicKey, PrivateKey clientPrivateKey) {
            this.settings = settings;
            this.settings.clientPublicKey = clientPublicKey;
            this.settings.clientPrivateKey = clientPrivateKey;
        }

        public TrustlyApiClientSettings andTrustlyCertificate() {
            if (TrustlyApiClientSettings.URL_PRODUCTION.equals(this.settings.getUrl())) {
                return this.andTrustlyCertificateProduction();
            }
            if (TrustlyApiClientSettings.URL_TEST.equals(this.settings.getUrl())) {
                return this.andTrustlyCertificateTest();
            }
            throw new IllegalArgumentException("You can only automatically choose the Trustly certificate if you used the ForProduction() or ForTest() builder steps");
        }

        public TrustlyApiClientSettings andTrustlyCertificateProduction() {
            return this.andTrustlyCertificateFromStream(this.getClass().getResourceAsStream("/keys/trustly_live_public.pem"));
        }

        public TrustlyApiClientSettings andTrustlyCertificateTest() {
            return this.andTrustlyCertificateFromStream(this.getClass().getResourceAsStream("/keys/trustly_test_public.pem"));
        }

        public TrustlyApiClientSettings andTrustlyCertificateFromUserHome(String trustlyPublicKeyFileName) throws IOException {
            trustlyPublicKeyFileName = trustlyPublicKeyFileName == null ? "trustly_public.pem" : trustlyPublicKeyFileName;
            String directory = TrustlyApiClientSettings.getUserHome();
            return this.andTrustlyCertificateFromDirectory(directory, trustlyPublicKeyFileName);
        }

        public TrustlyApiClientSettings andTrustlyCertificateFromDirectory(String directoryPath, String trustlyPublicKeyFileName) throws IOException {
            trustlyPublicKeyFileName = trustlyPublicKeyFileName == null ? "trustly_public.pem" : trustlyPublicKeyFileName;
            return this.andTrustlyCertificateFromFile(Paths.get(directoryPath, trustlyPublicKeyFileName).toString());
        }

        public TrustlyApiClientSettings andTrustlyCertificateFromFile(String filePath) throws IOException {
            try (FileInputStream publicFileStream = new FileInputStream(filePath);){
                TrustlyApiClientSettings trustlyApiClientSettings = this.andTrustlyCertificateFromStream(publicFileStream);
                return trustlyApiClientSettings;
            }
        }

        public TrustlyApiClientSettings andTrustlyCertificateFromStream(InputStream stream) {
            try {
                this.settings.trustlyPublicKey = TrustlyApiClientSettings.streamToJavaPublicKey(stream, null);
                if (this.settings.trustlyPublicKey == null) {
                    throw new IllegalArgumentException("Failed to load Trustly public key from stream");
                }
                if (TrustlyStringUtils.isBlank(this.settings.getUsername())) {
                    throw new IllegalArgumentException("The username must be set");
                }
                if (TrustlyStringUtils.isBlank(this.settings.getPassword())) {
                    throw new IllegalArgumentException("The password must be set");
                }
                return this.settings;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not load Trustly certificate from input stream", ex);
            }
        }
    }

    public static class WithCredentials {
        private final TrustlyApiClientSettings settings;

        public WithCredentials(TrustlyApiClientSettings settings, String username, String password) {
            this.settings = settings;
            this.settings.username = username;
            this.settings.password = password;
        }

        /*
         * Exception decompiling
         */
        public WithClientCertificates withCertificatesFromEnv(String envCertPublic, String envCertPrivate) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public WithClientCertificates withCertificatesFromUserHome() {
            return this.withCertificatesFromUserHome(null, null);
        }

        public WithClientCertificates withCertificatesFromUserHome(String clientPublicKeyFileName, String clientPrivateKeyFileName) {
            clientPublicKeyFileName = clientPublicKeyFileName == null ? "trustly_client_public.pem" : clientPublicKeyFileName;
            clientPrivateKeyFileName = clientPrivateKeyFileName == null ? "trustly_client_private.pem" : clientPrivateKeyFileName;
            String directory = TrustlyApiClientSettings.getUserHome();
            return this.withCertificatesFromDirectory(directory, clientPublicKeyFileName, clientPrivateKeyFileName);
        }

        public WithClientCertificates withCertificatesFromDirectory(String directoryPath, String clientPublicKeyFileName, String clientPrivateKeyFileName) {
            clientPublicKeyFileName = clientPublicKeyFileName == null ? "trustly_client_public.pem" : clientPublicKeyFileName;
            clientPrivateKeyFileName = clientPrivateKeyFileName == null ? "trustly_client_private.pem" : clientPrivateKeyFileName;
            return this.withCertificatesFromFiles(Paths.get(directoryPath, clientPublicKeyFileName).toString(), Paths.get(directoryPath, clientPrivateKeyFileName).toString());
        }

        /*
         * Exception decompiling
         */
        public WithClientCertificates withCertificatesFromFiles(String clientPublicKeyPath, String clientPrivateKeyPath) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public WithClientCertificates withCertificatesFromStreams(InputStream publicFileStream, InputStream privateFileStream) {
            try {
                PublicKey javaPublicKey = TrustlyApiClientSettings.streamToJavaPublicKey(publicFileStream, null);
                PrivateKey javaPrivateKey = TrustlyApiClientSettings.streamToJavaPrivateKey(privateFileStream, null);
                return new WithClientCertificates(this.settings, javaPublicKey, javaPrivateKey);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not initialize with certificates from stream", ex);
            }
        }
    }

    public static class WithEnvironment {
        private final TrustlyApiClientSettings settings;

        public WithEnvironment(TrustlyApiClientSettings settings, String url) {
            this.settings = settings;
            this.settings.url = url;
        }

        public WithCredentials withoutCredentials() {
            return new WithCredentials(this.settings, null, null);
        }

        public WithCredentials withCredentials(String username, String password) {
            return new WithCredentials(this.settings, username, password);
        }

        public WithCredentials withCredentialsFromEnv(String envUsername, String envPassword) {
            envUsername = envUsername == null ? "CLIENT_USERNAME" : envUsername;
            envPassword = envPassword == null ? "CLIENT_PASSWORD" : envPassword;
            return new WithCredentials(this.settings, System.getenv(envUsername), System.getenv(envPassword));
        }

        public WithCredentials withCredentialsFromUserHome() {
            return this.withCredentialsFromUserHome(null, null);
        }

        public WithCredentials withCredentialsFromUserHome(String clientUsernameFileName, String clientPasswordFileName) {
            String directory = TrustlyApiClientSettings.getUserHome();
            try {
                return this.withCredentialsFromDirectory(directory, clientUsernameFileName, clientPasswordFileName);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not load credentials from user home", ex);
            }
        }

        public WithCredentials withCredentialsFromDirectory(String directoryPath, String clientUsernameFileName, String clientPasswordFileName) throws IOException {
            clientUsernameFileName = clientUsernameFileName == null ? "trustly_client_username.txt" : null;
            clientPasswordFileName = clientPasswordFileName == null ? "trustly_client_password.txt" : null;
            String usernamePath = Paths.get(directoryPath, clientUsernameFileName).toString();
            String passwordPath = Paths.get(directoryPath, clientPasswordFileName).toString();
            return this.withCredentialsFromFiles(usernamePath, passwordPath);
        }

        public WithCredentials withCredentialsFromFiles(String usernamePath, String passwordPath) throws IOException {
            if (!new File(usernamePath).exists()) {
                throw new IllegalArgumentException(String.format("Cannot create api settings since username key file %s is missing", usernamePath));
            }
            if (!new File(passwordPath).exists()) {
                throw new IllegalArgumentException(String.format("Cannot create api settings since password key file %s is missing", passwordPath));
            }
            return new WithCredentials(this.settings, TrustlyFileUtils.readAllText(usernamePath).trim(), TrustlyFileUtils.readAllText(passwordPath).trim());
        }
    }
}

