/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.trustly.api.domain.base.IRequestParams;
import com.trustly.api.domain.base.IRequestParamsData;
import jakarta.validation.Valid;

@JsonDeserialize(builder=JsonRpcRequestBuilder.class)
public final class JsonRpcRequest<D extends IRequestParamsData> {
    @JsonProperty(value="method")
    private final String method;
    @JsonProperty(value="params")
    @Valid
    private final IRequestParams<D> params;
    @JsonProperty(value="version")
    private final double version;

    private static <D extends IRequestParamsData> double $default$version() {
        return 1.1;
    }

    public static <D extends IRequestParamsData> JsonRpcRequestBuilder<D> builder() {
        return new JsonRpcRequestBuilder();
    }

    public JsonRpcRequestBuilder<D> toBuilder() {
        return new JsonRpcRequestBuilder().method(this.method).params(this.params).version(this.version);
    }

    public String getMethod() {
        return this.method;
    }

    public IRequestParams<D> getParams() {
        return this.params;
    }

    public double getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonRpcRequest)) {
            return false;
        }
        JsonRpcRequest other = (JsonRpcRequest)o;
        if (Double.compare(this.getVersion(), other.getVersion()) != 0) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        IRequestParams<D> this$params = this.getParams();
        IRequestParams<D> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = Double.doubleToLongBits(this.getVersion());
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        IRequestParams<D> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public String toString() {
        return "JsonRpcRequest(method=" + this.getMethod() + ", params=" + this.getParams() + ", version=" + this.getVersion() + ")";
    }

    public JsonRpcRequest(String method, IRequestParams<D> params, double version) {
        this.method = method;
        this.params = params;
        this.version = version;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class JsonRpcRequestBuilder<D extends IRequestParamsData> {
        private String method;
        private IRequestParams<D> params;
        private boolean version$set;
        private double version$value;

        JsonRpcRequestBuilder() {
        }

        @JsonProperty(value="method")
        public JsonRpcRequestBuilder<D> method(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="params")
        public JsonRpcRequestBuilder<D> params(IRequestParams<D> params) {
            this.params = params;
            return this;
        }

        @JsonProperty(value="version")
        public JsonRpcRequestBuilder<D> version(double version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public JsonRpcRequest<D> build() {
            double version$value = this.version$value;
            if (!this.version$set) {
                version$value = JsonRpcRequest.$default$version();
            }
            return new JsonRpcRequest<D>(this.method, this.params, version$value);
        }

        public String toString() {
            return "JsonRpcRequest.JsonRpcRequestBuilder(method=" + this.method + ", params=" + this.params + ", version$value=" + this.version$value + ")";
        }
    }
}

