/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.base;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.trustly.api.domain.base.IData;
import com.trustly.api.domain.base.IResponseResultData;
import com.trustly.api.domain.base.ResponseError;
import com.trustly.api.domain.base.ResponseResult;
import jakarta.validation.Valid;

@JsonDeserialize(builder=JsonRpcResponseBuilder.class)
public final class JsonRpcResponse<D extends IResponseResultData> {
    private final String version;
    @Valid
    private final ResponseResult<D> result;
    @Valid
    private final ResponseError error;

    public boolean isSuccessfulResult() {
        return this.result != null && this.error == null;
    }

    public String getUUID() {
        return this.isSuccessfulResult() ? this.result.getUuid() : this.error.getError().getUuid();
    }

    public IData getData() {
        if (this.isSuccessfulResult()) {
            return this.result.getData();
        }
        if (this.error != null && this.error.getError() != null) {
            return this.error.getError().getData();
        }
        return null;
    }

    public String getMethod() {
        return this.isSuccessfulResult() ? this.result.getMethod() : this.error.getError().getMethod();
    }

    public String getSignature() {
        return this.isSuccessfulResult() ? this.result.getSignature() : this.error.getError().getSignature();
    }

    public static <D extends IResponseResultData> JsonRpcResponseBuilder<D> builder() {
        return new JsonRpcResponseBuilder();
    }

    public JsonRpcResponseBuilder<D> toBuilder() {
        return new JsonRpcResponseBuilder().version(this.version).result(this.result).error(this.error);
    }

    public String getVersion() {
        return this.version;
    }

    public ResponseResult<D> getResult() {
        return this.result;
    }

    public ResponseError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonRpcResponse)) {
            return false;
        }
        JsonRpcResponse other = (JsonRpcResponse)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        ResponseResult<D> this$result = this.getResult();
        ResponseResult<D> other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        ResponseError this$error = this.getError();
        ResponseError other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        ResponseResult<D> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        ResponseError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "JsonRpcResponse(version=" + this.getVersion() + ", result=" + this.getResult() + ", error=" + this.getError() + ")";
    }

    public JsonRpcResponse(String version, ResponseResult<D> result, ResponseError error) {
        this.version = version;
        this.result = result;
        this.error = error;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class JsonRpcResponseBuilder<D extends IResponseResultData> {
        private String version;
        private ResponseResult<D> result;
        private ResponseError error;

        JsonRpcResponseBuilder() {
        }

        public JsonRpcResponseBuilder<D> version(String version) {
            this.version = version;
            return this;
        }

        public JsonRpcResponseBuilder<D> result(ResponseResult<D> result) {
            this.result = result;
            return this;
        }

        public JsonRpcResponseBuilder<D> error(ResponseError error) {
            this.error = error;
            return this;
        }

        public JsonRpcResponse<D> build() {
            return new JsonRpcResponse<D>(this.version, this.result, this.error);
        }

        public String toString() {
            return "JsonRpcResponse.JsonRpcResponseBuilder(version=" + this.version + ", result=" + this.result + ", error=" + this.error + ")";
        }
    }
}

