/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.trustly.api.domain.base.IFromTrustlyRequestData;
import com.trustly.api.domain.base.IRequest;
import com.trustly.api.domain.base.IRequestParams;
import com.trustly.api.domain.base.NotificationRequestParams;
import jakarta.validation.Valid;

@JsonDeserialize(builder=NotificationRequestBuilder.class)
public final class NotificationRequest<D extends IFromTrustlyRequestData>
implements IRequest<NotificationRequestParams<D>> {
    @JsonProperty(value="method")
    private final String method;
    @JsonProperty(value="params")
    @Valid
    private final NotificationRequestParams<D> params;
    @JsonProperty(value="version")
    private final double version;

    private static <D extends IFromTrustlyRequestData> double $default$version() {
        return 1.1;
    }

    public static <D extends IFromTrustlyRequestData> NotificationRequestBuilder<D> builder() {
        return new NotificationRequestBuilder();
    }

    public NotificationRequestBuilder<D> toBuilder() {
        return new NotificationRequestBuilder().method(this.method).params(this.params).version(this.version);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public NotificationRequestParams<D> getParams() {
        return this.params;
    }

    @Override
    public double getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRequest)) {
            return false;
        }
        NotificationRequest other = (NotificationRequest)o;
        if (Double.compare(this.getVersion(), other.getVersion()) != 0) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        IRequestParams this$params = this.getParams();
        IRequestParams other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = Double.doubleToLongBits(this.getVersion());
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        IRequestParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public String toString() {
        return "NotificationRequest(method=" + this.getMethod() + ", params=" + this.getParams() + ", version=" + this.getVersion() + ")";
    }

    public NotificationRequest(String method, NotificationRequestParams<D> params, double version) {
        this.method = method;
        this.params = params;
        this.version = version;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class NotificationRequestBuilder<D extends IFromTrustlyRequestData> {
        private String method;
        private NotificationRequestParams<D> params;
        private boolean version$set;
        private double version$value;

        NotificationRequestBuilder() {
        }

        @JsonProperty(value="method")
        public NotificationRequestBuilder<D> method(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="params")
        public NotificationRequestBuilder<D> params(NotificationRequestParams<D> params) {
            this.params = params;
            return this;
        }

        @JsonProperty(value="version")
        public NotificationRequestBuilder<D> version(double version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public NotificationRequest<D> build() {
            double version$value = this.version$value;
            if (!this.version$set) {
                version$value = NotificationRequest.$default$version();
            }
            return new NotificationRequest<D>(this.method, this.params, version$value);
        }

        public String toString() {
            return "NotificationRequest.NotificationRequestBuilder(method=" + this.method + ", params=" + this.params + ", version$value=" + this.version$value + ")";
        }
    }
}

