/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.methods.deposit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.trustly.api.domain.base.AbstractToTrustlyRequestData;
import com.trustly.api.domain.common.DepositValidationGroup;
import com.trustly.api.domain.methods.deposit.DepositRequestDataAttributes;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.groups.ConvertGroup;
import org.hibernate.validator.constraints.URL;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=DepositRequestDataBuilderImpl.class)
public class DepositRequestData
extends AbstractToTrustlyRequestData<DepositRequestDataAttributes> {
    @JsonProperty(value="NotificationURL")
    @NotBlank
    @URL
    private String notificationUrl;
    @JsonProperty(value="EndUserID")
    @NotBlank
    private String endUserId;
    @JsonProperty(value="MessageID")
    @NotBlank
    private String messageId;

    @Override
    @JsonProperty(value="Attributes", required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Valid
    @ConvertGroup(to=DepositValidationGroup.class)
    public DepositRequestDataAttributes getAttributes() {
        return (DepositRequestDataAttributes)super.getAttributes();
    }

    protected DepositRequestData(DepositRequestDataBuilder<?, ?> b) {
        super(b);
        this.notificationUrl = ((DepositRequestDataBuilder)b).notificationUrl;
        this.endUserId = ((DepositRequestDataBuilder)b).endUserId;
        this.messageId = ((DepositRequestDataBuilder)b).messageId;
    }

    public static DepositRequestDataBuilder<?, ?> builder() {
        return new DepositRequestDataBuilderImpl();
    }

    public DepositRequestDataBuilder<?, ?> toBuilder() {
        return new DepositRequestDataBuilderImpl().$fillValuesFrom(this);
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public String getEndUserId() {
        return this.endUserId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="NotificationURL")
    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    @JsonProperty(value="EndUserID")
    public void setEndUserId(String endUserId) {
        this.endUserId = endUserId;
    }

    @JsonProperty(value="MessageID")
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public String toString() {
        return "DepositRequestData(notificationUrl=" + this.getNotificationUrl() + ", endUserId=" + this.getEndUserId() + ", messageId=" + this.getMessageId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositRequestData)) {
            return false;
        }
        DepositRequestData other = (DepositRequestData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$notificationUrl = this.getNotificationUrl();
        String other$notificationUrl = other.getNotificationUrl();
        if (this$notificationUrl == null ? other$notificationUrl != null : !this$notificationUrl.equals(other$notificationUrl)) {
            return false;
        }
        String this$endUserId = this.getEndUserId();
        String other$endUserId = other.getEndUserId();
        if (this$endUserId == null ? other$endUserId != null : !this$endUserId.equals(other$endUserId)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepositRequestData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $notificationUrl = this.getNotificationUrl();
        result = result * 59 + ($notificationUrl == null ? 43 : $notificationUrl.hashCode());
        String $endUserId = this.getEndUserId();
        result = result * 59 + ($endUserId == null ? 43 : $endUserId.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        return result;
    }

    public DepositRequestData() {
    }

    public DepositRequestData(String notificationUrl, String endUserId, String messageId) {
        this.notificationUrl = notificationUrl;
        this.endUserId = endUserId;
        this.messageId = messageId;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class DepositRequestDataBuilderImpl
    extends DepositRequestDataBuilder<DepositRequestData, DepositRequestDataBuilderImpl> {
        private DepositRequestDataBuilderImpl() {
        }

        @Override
        protected DepositRequestDataBuilderImpl self() {
            return this;
        }

        @Override
        public DepositRequestData build() {
            return new DepositRequestData(this);
        }
    }

    public static abstract class DepositRequestDataBuilder<C extends DepositRequestData, B extends DepositRequestDataBuilder<C, B>>
    extends AbstractToTrustlyRequestData.AbstractToTrustlyRequestDataBuilder<DepositRequestDataAttributes, C, B> {
        private String notificationUrl;
        private String endUserId;
        private String messageId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DepositRequestDataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DepositRequestData instance, DepositRequestDataBuilder<?, ?> b) {
            b.notificationUrl(instance.notificationUrl);
            b.endUserId(instance.endUserId);
            b.messageId(instance.messageId);
        }

        @JsonProperty(value="NotificationURL")
        public B notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            return (B)this.self();
        }

        @JsonProperty(value="EndUserID")
        public B endUserId(String endUserId) {
            this.endUserId = endUserId;
            return (B)this.self();
        }

        @JsonProperty(value="MessageID")
        public B messageId(String messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DepositRequestData.DepositRequestDataBuilder(super=" + super.toString() + ", notificationUrl=" + this.notificationUrl + ", endUserId=" + this.endUserId + ", messageId=" + this.messageId + ")";
        }
    }
}

