/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.methods.settlementreport;

import com.trustly.api.domain.methods.settlementreport.SettlementReportResponseDataEntry;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SettlementReportParser {
    private static final Mapper NOOP_MAPPER = (row, value) -> {};
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().toFormatter(Locale.ROOT), DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT};
    private final Map<String, Mapper> mappers = new HashMap<String, Mapper>();

    public SettlementReportParser() {
        this.mappers.put("accountname", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::accountName);
        this.mappers.put("currency", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::currency);
        this.mappers.put("messageid", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::messageId);
        this.mappers.put("orderid", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::orderId);
        this.mappers.put("ordertype", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::orderType);
        this.mappers.put("username", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::username);
        this.mappers.put("fxpaymentcurrency", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::fxPaymentCurrency);
        this.mappers.put("settlementbankwithdrawalid", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::settlementBankWithdrawalId);
        this.mappers.put("externalreference", SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder::externalReference);
        this.mappers.put("amount", (row, value) -> row.amount(Double.parseDouble(value)));
        this.mappers.put("fxpaymentamount", (row, value) -> row.fxPaymentAmount(Double.parseDouble(value)));
        this.mappers.put("total", (row, value) -> row.total(Double.parseDouble(value)));
        this.mappers.put("datestamp", (row, value) -> {
            ArrayList<DateTimeParseException> exceptions = new ArrayList<DateTimeParseException>();
            for (DateTimeFormatter formatter : DATE_TIME_FORMATTERS) {
                try {
                    row.datestamp(formatter.parse((CharSequence)value, Instant::from));
                    return;
                }
                catch (DateTimeParseException ex) {
                    exceptions.add(ex);
                }
            }
            throw (DateTimeParseException)exceptions.stream().findFirst().orElseThrow(() -> new IllegalStateException("Unknown date format exception"));
        });
    }

    public List<SettlementReportResponseDataEntry> parse(String csv) {
        String[] lines = csv.replace("\r", "").trim().split("\n");
        ArrayList<SettlementReportResponseDataEntry> rows = new ArrayList<SettlementReportResponseDataEntry>();
        if (lines.length == 0) {
            return rows;
        }
        String[] headers = lines[0].split(",");
        ArrayList<Mapper> localMappers = new ArrayList<Mapper>();
        for (String header : headers) {
            String lowerCaseHeaderKey = header.toLowerCase(Locale.ROOT);
            if (this.mappers.containsKey(lowerCaseHeaderKey)) {
                localMappers.add(this.mappers.get(lowerCaseHeaderKey));
                continue;
            }
            localMappers.add(NOOP_MAPPER);
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || line.isEmpty()) continue;
            String[] fieldsValues = this.getFieldValues(line);
            SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder rowBuilder = SettlementReportResponseDataEntry.builder();
            for (int columnIndex = 0; columnIndex < fieldsValues.length; ++columnIndex) {
                if (fieldsValues[columnIndex] == null || fieldsValues[columnIndex].isEmpty()) continue;
                ((Mapper)localMappers.get(columnIndex)).map(rowBuilder, fieldsValues[columnIndex]);
            }
            rows.add(rowBuilder.build());
        }
        return rows;
    }

    private String[] getFieldValues(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        boolean insideQuote = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (insideQuote) {
                if (c == '\"') {
                    insideQuote = false;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\"') {
                insideQuote = true;
                continue;
            }
            if (c == ',') {
                tokens.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            tokens.add(buffer.toString());
            buffer.setLength(0);
        }
        return tokens.toArray(new String[0]);
    }

    @FunctionalInterface
    public static interface Mapper {
        public void map(SettlementReportResponseDataEntry.SettlementReportResponseDataEntryBuilder var1, String var2);
    }
}

