/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.domain.methods.settlementreport;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.trustly.api.domain.base.AbstractResponseResultData;
import com.trustly.api.domain.methods.settlementreport.SettlementReportParser;
import com.trustly.api.domain.methods.settlementreport.SettlementReportResponseDataEntry;
import java.util.List;

@JsonDeserialize(builder=SettlementReportResponseDataBuilderImpl.class)
public final class SettlementReportResponseData
extends AbstractResponseResultData {
    private final String csvContent;
    @JsonIgnore
    private final List<SettlementReportResponseDataEntry> entries;

    @JsonCreator
    public SettlementReportResponseData(@JsonProperty(value="view_automatic_settlement_details") String csvContent) {
        this.csvContent = csvContent;
        this.entries = new SettlementReportParser().parse(csvContent);
    }

    protected SettlementReportResponseData(SettlementReportResponseDataBuilder<?, ?> b) {
        super(b);
        this.csvContent = ((SettlementReportResponseDataBuilder)b).csvContent;
        this.entries = ((SettlementReportResponseDataBuilder)b).entries;
    }

    public static SettlementReportResponseDataBuilder<?, ?> builder() {
        return new SettlementReportResponseDataBuilderImpl();
    }

    public String getCsvContent() {
        return this.csvContent;
    }

    public List<SettlementReportResponseDataEntry> getEntries() {
        return this.entries;
    }

    @Override
    public String toString() {
        return "SettlementReportResponseData(csvContent=" + this.getCsvContent() + ", entries=" + this.getEntries() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettlementReportResponseData)) {
            return false;
        }
        SettlementReportResponseData other = (SettlementReportResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$csvContent = this.getCsvContent();
        String other$csvContent = other.getCsvContent();
        if (this$csvContent == null ? other$csvContent != null : !this$csvContent.equals(other$csvContent)) {
            return false;
        }
        List<SettlementReportResponseDataEntry> this$entries = this.getEntries();
        List<SettlementReportResponseDataEntry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SettlementReportResponseData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $csvContent = this.getCsvContent();
        result = result * 59 + ($csvContent == null ? 43 : $csvContent.hashCode());
        List<SettlementReportResponseDataEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public SettlementReportResponseData(String csvContent, List<SettlementReportResponseDataEntry> entries) {
        this.csvContent = csvContent;
        this.entries = entries;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SettlementReportResponseDataBuilderImpl
    extends SettlementReportResponseDataBuilder<SettlementReportResponseData, SettlementReportResponseDataBuilderImpl> {
        private SettlementReportResponseDataBuilderImpl() {
        }

        @Override
        protected SettlementReportResponseDataBuilderImpl self() {
            return this;
        }

        @Override
        public SettlementReportResponseData build() {
            return new SettlementReportResponseData(this);
        }
    }

    public static abstract class SettlementReportResponseDataBuilder<C extends SettlementReportResponseData, B extends SettlementReportResponseDataBuilder<C, B>>
    extends AbstractResponseResultData.AbstractResponseResultDataBuilder<C, B> {
        private String csvContent;
        private List<SettlementReportResponseDataEntry> entries;

        public B csvContent(String csvContent) {
            this.csvContent = csvContent;
            return (B)this.self();
        }

        @JsonIgnore
        public B entries(List<SettlementReportResponseDataEntry> entries) {
            this.entries = entries;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SettlementReportResponseData.SettlementReportResponseDataBuilder(super=" + super.toString() + ", csvContent=" + this.csvContent + ", entries=" + this.entries + ")";
        }
    }
}

