/*
 * Decompiled with CFR 0.152.
 */
package com.trustly.api.validation;

import com.trustly.api.validation.AnnotationsValidator;
import com.trustly.api.validation.ValidationResult;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.validator.internal.engine.resolver.TraversableResolvers;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class HibernateDataAnnotationsValidator
implements AnnotationsValidator {
    private static final List<ValidationResult> EMPTY_VALIDATION_RESULTS = Collections.unmodifiableList(new ArrayList());
    private Validator validator;

    @Override
    public <T> List<ValidationResult> validate(T obj) {
        if (this.validator == null) {
            this.validator = Validation.byDefaultProvider().configure().traversableResolver(TraversableResolvers.getDefault()).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (ConstraintViolation validation : this.validator.validate(obj, new Class[0])) {
            errorMessages.add(validation.getPropertyPath() + ": " + validation.getMessage());
        }
        if (!errorMessages.isEmpty()) {
            return errorMessages.stream().map(ValidationResult::new).collect(Collectors.toList());
        }
        return EMPTY_VALIDATION_RESULTS;
    }
}

