/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.mvc.MvcConfiguration;
import com.truthbean.debbie.mvc.request.RouterRequest;
import com.truthbean.debbie.mvc.response.RouterResponse;
import com.truthbean.debbie.mvc.router.MvcRouterHandler;
import com.truthbean.debbie.mvc.router.RouterInfo;
import com.truthbean.debbie.servlet.ServletConfiguration;
import com.truthbean.debbie.servlet.request.HttpServletRequestWrapper;
import com.truthbean.debbie.servlet.response.ServletResponseHandler;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = -8253171030384092538L;
    private final ServletConfiguration configuration;
    private final ApplicationContext handler;
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherServlet.class);

    public void init() throws ServletException {
        super.init();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public DispatcherServlet(ServletConfiguration configuration, ApplicationContext handler) {
        this.configuration = configuration;
        this.handler = handler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatcher(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatcher(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatcher(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatcher(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatcher(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    private void dispatcher(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("dispatcher servlet .... ");
        HttpServletRequestWrapper requestWrapper = req instanceof HttpServletRequestWrapper ? (HttpServletRequestWrapper)req : new HttpServletRequestWrapper(req);
        RouterRequest routerRequest = requestWrapper.getRouterRequest();
        byte[] bytes = MvcRouterHandler.handleStaticResources((RouterRequest)routerRequest, (Map)this.configuration.getStaticResourcesMapping());
        if (bytes != null) {
            resp.setContentLength(bytes.length);
            try (ServletOutputStream outputStream = resp.getOutputStream();){
                outputStream.write(bytes);
            }
            catch (IOException e) {
                LOGGER.error(" ", (Throwable)e);
            }
        } else {
            RouterInfo routerInfo = MvcRouterHandler.getMatchedRouter((RouterRequest)routerRequest, (MvcConfiguration)this.configuration);
            RouterResponse response = MvcRouterHandler.handleRouter((RouterInfo)routerInfo, (ApplicationContext)this.handler);
            ServletResponseHandler handler = new ServletResponseHandler(req, resp);
            handler.changeResponseWithoutContent(response);
            handler.handle(response, routerInfo.getDefaultResponseType());
        }
    }
}

