/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.debbie.core.AbstractApplicationFactory;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.mvc.router.Router;
import com.truthbean.debbie.servlet.ServletContextHandler;
import com.truthbean.debbie.watcher.Watcher;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import java.util.Set;

@HandlesTypes(value={Watcher.class, Router.class})
public class ServletApplicationInitializer
extends AbstractApplicationFactory
implements ServletContainerInitializer {
    private final ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletApplicationInitializer.class);

    public ServletApplicationInitializer() {
        super(ServletApplicationInitializer.class, new String[0]);
        if (debbieApplication == null) {
            LOGGER.debug("run servlet module without application");
            this.applicationContext = this.getApplicationContext();
            super.config(ServletApplicationInitializer.class);
            super.callStarter();
        } else {
            this.applicationContext = super.getApplicationContext();
        }
    }

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        LOGGER.info("ServletContainerInitializer onStartup ...");
        ServletContextHandler handler = new ServletContextHandler(ctx, this.applicationContext);
        handler.registerRouter();
        handler.registerFilter(ctx);
        if (debbieApplication == null) {
            super.postCallStarter(this.factory());
        }
    }
}

