/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import com.truthbean.debbie.bean.BeanInfoManager;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.mvc.MvcConfiguration;
import com.truthbean.debbie.mvc.csrf.CsrfFilter;
import com.truthbean.debbie.mvc.filter.CharacterEncodingFilter;
import com.truthbean.debbie.mvc.filter.CorsFilter;
import com.truthbean.debbie.mvc.filter.RouterFilter;
import com.truthbean.debbie.mvc.filter.RouterFilterManager;
import com.truthbean.debbie.mvc.filter.SecurityFilter;
import com.truthbean.debbie.mvc.router.MvcRouterRegister;
import com.truthbean.debbie.servlet.DispatcherServlet;
import com.truthbean.debbie.servlet.ServletConfiguration;
import com.truthbean.debbie.servlet.ServletProperties;
import com.truthbean.debbie.servlet.StaticResourcesServlet;
import com.truthbean.debbie.servlet.filter.RouterFilterWrapper;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class ServletContextHandler {
    private final ApplicationContext applicationContext;
    private final BeanInfoManager beanInitialization;
    private final ClassLoader classLoader;
    private ServletConfiguration servletConfiguration;

    public ServletContextHandler(ServletContext servletContext, ApplicationContext handler) {
        this.setServletConfiguration();
        this.beanInitialization = handler.getBeanInfoManager();
        this.applicationContext = handler;
        this.classLoader = this.applicationContext.getClassLoader();
        this.handleServletContext(servletContext);
    }

    private void setServletConfiguration() {
        this.servletConfiguration = ServletProperties.isPropertiesEmpty() ? new ServletConfiguration(this.classLoader) : ServletProperties.toConfiguration(this.classLoader);
    }

    private void handleServletContext(ServletContext servletContext) {
        StaticResourcesServlet staticResourcesServlet = new StaticResourcesServlet(this.servletConfiguration, this.applicationContext);
        Map staticResourcesMapping = this.servletConfiguration.getStaticResourcesMapping();
        String[] staticResourcesMappings = new String[staticResourcesMapping.size()];
        String[] keySet = staticResourcesMapping.keySet().toArray(new String[0]);
        int length = keySet.length;
        for (int i = 0; i < length; ++i) {
            staticResourcesMappings[i] = keySet[i].replace("**", "*");
        }
        servletContext.addServlet("staticResourcesServlet", (Servlet)staticResourcesServlet).addMapping(staticResourcesMappings);
        DispatcherServlet dispatcherServlet = new DispatcherServlet(this.servletConfiguration, this.applicationContext);
        String dispatcherMapping = this.servletConfiguration.getDispatcherMapping().replace("**", "*");
        servletContext.addServlet("dispatcherHandler", (Servlet)dispatcherServlet).addMapping(new String[]{dispatcherMapping});
    }

    public void registerRouter() {
        MvcRouterRegister.registerRouter((MvcConfiguration)this.servletConfiguration, (ApplicationContext)this.applicationContext);
    }

    public void registerFilter(ServletContext servletContext) {
        RouterFilterManager.registerFilter((MvcConfiguration)this.servletConfiguration, (BeanInfoManager)this.beanInitialization);
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.ERROR);
        RouterFilterWrapper charsetEncodingFilter = new RouterFilterWrapper((RouterFilter)new CharacterEncodingFilter().setMvcConfiguration((MvcConfiguration)this.servletConfiguration), this.servletConfiguration.getDefaultContentType());
        servletContext.addFilter("characterEncodingFilter", (Filter)charsetEncodingFilter).addMappingForUrlPatterns(dispatcherTypes, true, new String[]{"/*"});
        RouterFilterWrapper corsFilter = new RouterFilterWrapper((RouterFilter)new CorsFilter().setMvcConfiguration((MvcConfiguration)this.servletConfiguration), this.servletConfiguration.getDefaultContentType());
        servletContext.addFilter("corsFilter", (Filter)corsFilter).addMappingForUrlPatterns(dispatcherTypes, true, new String[]{"/*"});
        if (this.servletConfiguration.isEnableCrsf()) {
            RouterFilterWrapper csrfFilter = new RouterFilterWrapper((RouterFilter)new CsrfFilter().setMvcConfiguration((MvcConfiguration)this.servletConfiguration), this.servletConfiguration.getDefaultContentType());
            servletContext.addFilter("csrfFilter", (Filter)csrfFilter).addMappingForUrlPatterns(dispatcherTypes, true, new String[]{"/*"});
        }
        if (this.servletConfiguration.isEnableSecurity()) {
            RouterFilterWrapper securityFilter = new RouterFilterWrapper((RouterFilter)new SecurityFilter().setMvcConfiguration((MvcConfiguration)this.servletConfiguration), this.servletConfiguration.getDefaultContentType());
            servletContext.addFilter("securityFilter", (Filter)securityFilter).addMappingForUrlPatterns(dispatcherTypes, true, new String[]{"/*"});
        }
        Set filters = RouterFilterManager.getFilters();
        filters.forEach(filter -> {
            RouterFilterWrapper filterWrapper = new RouterFilterWrapper(filter.getRouterFilterType(), this.applicationContext, this.servletConfiguration.getDefaultContentType());
            servletContext.addFilter(filter.getName(), (Filter)filterWrapper).addMappingForUrlPatterns(dispatcherTypes, true, filter.getUrlPatterns());
        });
    }
}

