/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import com.truthbean.common.mini.util.StringUtils;
import com.truthbean.debbie.bean.BeanScanConfiguration;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.env.EnvironmentContentHolder;
import com.truthbean.debbie.mvc.MvcConfiguration;
import com.truthbean.debbie.mvc.MvcProperties;
import com.truthbean.debbie.properties.ClassesScanProperties;
import com.truthbean.debbie.properties.DebbieProperties;
import com.truthbean.debbie.servlet.ServletConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServletProperties
extends EnvironmentContentHolder
implements DebbieProperties<ServletConfiguration> {
    private final Map<String, ServletConfiguration> map = new HashMap<String, ServletConfiguration>();
    private static ServletConfiguration configuration;

    public static ServletConfiguration toConfiguration(ClassLoader classLoader) {
        if (configuration != null) {
            return configuration;
        }
        configuration = new ServletConfiguration(classLoader);
        MvcConfiguration webConfiguration = MvcProperties.toConfiguration((ClassLoader)classLoader);
        configuration.copyFrom(webConfiguration);
        BeanScanConfiguration beanScanConfiguration = ClassesScanProperties.toConfiguration((ClassLoader)classLoader);
        configuration.copyFrom(beanScanConfiguration);
        return configuration;
    }

    public Set<String> getProfiles() {
        return this.map.keySet();
    }

    public ServletConfiguration getConfiguration(String name, ApplicationContext applicationContext) {
        if ("default".equals(name) || !StringUtils.hasText((String)name)) {
            return this.getConfiguration(applicationContext);
        }
        return this.map.get(name);
    }

    public ServletConfiguration getConfiguration(ApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        return ServletProperties.toConfiguration(classLoader);
    }

    public void close() throws Exception {
        this.map.clear();
        configuration = null;
    }
}

