/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import jakarta.servlet.http.Cookie;
import java.net.HttpCookie;

public class ServletRouterCookie {
    private final HttpCookie httpCookie;
    private final Cookie cookie;

    public ServletRouterCookie(Cookie cookie) {
        this.cookie = cookie;
        this.httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        this.httpCookie.setValue(cookie.getValue());
        this.httpCookie.setPath(cookie.getPath());
        this.httpCookie.setDomain(cookie.getDomain());
        this.httpCookie.setMaxAge(cookie.getMaxAge());
        this.httpCookie.setDiscard(cookie.getMaxAge() < 0);
        this.httpCookie.setSecure(cookie.getSecure());
        this.httpCookie.setVersion(cookie.getVersion());
        this.httpCookie.setHttpOnly(cookie.isHttpOnly());
        this.httpCookie.setComment(cookie.getComment());
    }

    public ServletRouterCookie(HttpCookie httpCookie) {
        this.httpCookie = httpCookie;
        this.cookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
        this.cookie.setValue(httpCookie.getValue());
        this.cookie.setPath(httpCookie.getPath());
        String domain = httpCookie.getDomain();
        if (domain != null) {
            this.cookie.setDomain(httpCookie.getDomain());
        }
        this.cookie.setMaxAge(Math.toIntExact(httpCookie.getMaxAge()));
        this.cookie.setSecure(httpCookie.getSecure());
        this.cookie.setVersion(httpCookie.getVersion());
        this.cookie.setHttpOnly(httpCookie.isHttpOnly());
        this.cookie.setComment(httpCookie.getComment());
    }

    public HttpCookie getHttpCookie() {
        return this.httpCookie;
    }

    public Cookie getCookie() {
        return this.cookie;
    }
}

