/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.mvc.request.RouterRequest;
import com.truthbean.debbie.mvc.router.MvcRouterHandler;
import com.truthbean.debbie.servlet.ServletConfiguration;
import com.truthbean.debbie.servlet.request.HttpServletRequestWrapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class StaticResourcesServlet
extends HttpServlet {
    private final ServletConfiguration configuration;
    private final ApplicationContext applicationContext;
    public static final Logger LOGGER = LoggerFactory.getLogger(StaticResourcesServlet.class);

    public StaticResourcesServlet(ServletConfiguration configuration, ApplicationContext applicationContext) {
        this.configuration = configuration;
        this.applicationContext = applicationContext;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequestWrapper requestWrapper = req instanceof HttpServletRequestWrapper ? (HttpServletRequestWrapper)req : new HttpServletRequestWrapper(req);
        byte[] bytes = MvcRouterHandler.handleStaticResources((RouterRequest)requestWrapper.getRouterRequest(), (Map)this.configuration.getStaticResourcesMapping());
        if (bytes != null) {
            resp.setContentLength(bytes.length);
            try (ServletOutputStream outputStream = resp.getOutputStream();){
                outputStream.write(bytes);
            }
            catch (IOException e) {
                LOGGER.error(" ", (Throwable)e);
            }
        }
    }
}

