/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet.filter;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.debbie.bean.GlobalBeanFactory;
import com.truthbean.debbie.core.ApplicationContext;
import com.truthbean.debbie.io.MediaTypeInfo;
import com.truthbean.debbie.mvc.filter.RouterFilter;
import com.truthbean.debbie.mvc.request.RouterRequest;
import com.truthbean.debbie.mvc.response.HttpStatus;
import com.truthbean.debbie.mvc.response.RouterResponse;
import com.truthbean.debbie.servlet.request.HttpServletRequestWrapper;
import com.truthbean.debbie.servlet.response.HttpServletResponseWrapper;
import com.truthbean.debbie.servlet.response.ServletResponseHandler;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class RouterFilterWrapper
extends HttpFilter
implements RouterFilter {
    private RouterFilter filter;
    private Class<? extends RouterFilter> filterType;
    private final MediaTypeInfo defaultResponseType;
    private ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterFilterWrapper.class);

    public RouterFilterWrapper(Class<? extends RouterFilter> filterType, ApplicationContext applicationContext, MediaTypeInfo defaultResponseType) {
        this.filterType = filterType;
        this.applicationContext = applicationContext;
        this.defaultResponseType = defaultResponseType;
    }

    public RouterFilterWrapper(RouterFilter filter, MediaTypeInfo defaultResponseType) {
        this.filter = filter;
        this.defaultResponseType = defaultResponseType;
    }

    public boolean preRouter(RouterRequest request, RouterResponse response) {
        return this.filter.preRouter(request, response);
    }

    public Boolean postRouter(RouterRequest request, RouterResponse response) {
        return this.filter.postRouter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter == null) {
            RouterFilterWrapper routerFilterWrapper = this;
            synchronized (routerFilterWrapper) {
                if (this.filter == null) {
                    GlobalBeanFactory globalBeanFactory = this.applicationContext.getGlobalBeanFactory();
                    this.filter = (RouterFilter)globalBeanFactory.factory(this.filterType);
                }
            }
        }
        HttpServletRequestWrapper requestWrapper = request instanceof HttpServletRequestWrapper ? (HttpServletRequestWrapper)request : new HttpServletRequestWrapper(request);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("url(" + requestWrapper.getRequestURI() + ") with method(" + requestWrapper.getMethod() + ") filter by " + this.filterType);
        }
        RouterRequest routerRequest = requestWrapper.getRouterRequest();
        HttpServletResponseWrapper responseWrapper = response instanceof HttpServletResponseWrapper ? (HttpServletResponseWrapper)response : new HttpServletResponseWrapper(response);
        RouterResponse routerResponse = responseWrapper.getRouterResponse();
        boolean doFilter = false;
        if (this.preRouter(routerRequest, routerResponse)) {
            Map attributes = routerRequest.getAttributes();
            if (attributes != null && !attributes.isEmpty()) {
                attributes.forEach((arg_0, arg_1) -> ((HttpServletRequest)request).setAttribute(arg_0, arg_1));
            }
            doFilter = true;
        } else {
            Boolean post = this.postRouter(routerRequest, routerResponse);
            if (post != null) {
                ServletResponseHandler handler = new ServletResponseHandler(requestWrapper, responseWrapper.getResponse());
                if (post.booleanValue()) {
                    if (routerResponse.getStatus() == null) {
                        routerResponse.setStatus(HttpStatus.OK);
                    }
                    handler.changeResponseWithoutContent(routerResponse);
                    handler.handle(routerResponse, this.defaultResponseType, false);
                    doFilter = false;
                } else {
                    handler.changeResponseWithoutContent(routerResponse);
                    doFilter = true;
                }
            }
        }
        if (doFilter) {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
    }
}

