/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet.request;

import com.truthbean.debbie.io.FileNameUtils;
import com.truthbean.debbie.io.MediaType;
import com.truthbean.debbie.io.MediaTypeInfo;
import com.truthbean.debbie.io.MultipartFile;
import com.truthbean.debbie.io.StreamHelper;
import com.truthbean.debbie.mvc.RouterSession;
import com.truthbean.debbie.mvc.request.DefaultRouterRequest;
import com.truthbean.debbie.mvc.request.HttpHeader;
import com.truthbean.debbie.mvc.request.HttpMethod;
import com.truthbean.debbie.mvc.request.RequestBody;
import com.truthbean.debbie.mvc.request.RouterRequest;
import com.truthbean.debbie.net.uri.QueryStringDecoder;
import com.truthbean.debbie.net.uri.UriUtils;
import com.truthbean.debbie.servlet.ServletRouterCookie;
import com.truthbean.debbie.servlet.ServletRouterSession;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private final HttpServletRequest request;
    private final DefaultRouterRequest routerRequest;
    private final byte[] body;

    public HttpServletRequestWrapper(HttpServletRequest httpServletRequest) {
        this(UUID.randomUUID().toString(), httpServletRequest);
    }

    private HttpServletRequestWrapper(RouterRequest routerRequest, HttpServletRequest request) {
        this.routerRequest = new DefaultRouterRequest();
        this.request = request;
        this.routerRequest.copy(routerRequest);
        this.body = this.getBody();
    }

    private HttpServletRequestWrapper(String id, final HttpServletRequest httpServletRequest) {
        this.routerRequest = new DefaultRouterRequest(){

            public String getRealPath(String path) {
                return httpServletRequest.getServletContext().getRealPath(path);
            }

            public String getContextPath() {
                return httpServletRequest.getContextPath();
            }

            public void setCharacterEncoding(Charset charset) {
                try {
                    HttpServletRequestWrapper.this.request.setCharacterEncoding(charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        };
        this.request = httpServletRequest;
        this.routerRequest.setMethod(HttpMethod.valueOf((String)this.request.getMethod()));
        this.routerRequest.setUrl(this.request.getRequestURI());
        this.routerRequest.setMatrix(UriUtils.resolveMatrixByPath((String)this.routerRequest.getUrl()));
        this.routerRequest.setPathAttributes(new HashMap());
        this.setHeaders();
        this.setCookies();
        this.routerRequest.setMethod(HttpMethod.resolve((String)this.request.getMethod()));
        this.routerRequest.setSession((RouterSession)new ServletRouterSession(this.request));
        this.routerRequest.setQueries(this.queries(this.request.getQueryString()));
        this.body = this.getBody();
        this.setParams();
        this.setBody();
        this.setContentType();
        this.setResponseType();
        this.setRequestAttribute();
        this.routerRequest.setId(id);
    }

    private byte[] getBody() {
        String contentType = this.getHeader(HttpHeader.HttpHeaderNames.CONTENT_TYPE.getName());
        if (contentType == null || !contentType.startsWith("multipart/form")) {
            try {
                return StreamHelper.toByteArray((InputStream)this.request.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                return new byte[0];
            }
        }
        return new byte[0];
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    private void setHeaders() {
        HashMap map = new HashMap();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> value = new ArrayList<String>();
            Enumeration headers = this.request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                value.add((String)headers.nextElement());
            }
            map.put(headerName, value);
        }
        this.routerRequest.setHeaders(map);
    }

    private void setCookies() {
        Cookie[] cookies = this.request.getCookies();
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                result.add(new ServletRouterCookie(cookie).getHttpCookie());
            }
        }
        this.routerRequest.setCookies(result);
    }

    private void setParams() {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        Enumeration parameterNames = this.request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String[] values = this.request.getParameterValues(name);
            ArrayList<String> objects = new ArrayList<String>(Arrays.asList(values));
            map.put(name, objects);
        }
        Map<String, List<Object>> paramsInBody = this.getParamsInBody();
        if (!paramsInBody.isEmpty()) {
            map.putAll(paramsInBody);
        }
        this.routerRequest.setParameters(map);
    }

    private Map<String, List<Object>> getParamsInBody() {
        HttpHeader headers = this.routerRequest.getHeader();
        String type = MediaType.ANY.getValue();
        if (headers.getHeader("Content-Type") != null) {
            type = headers.getHeader("Content-Type");
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.getValue().equals(type)) {
            try {
                RequestBody requestBody = new RequestBody((InputStream)this.getInputStream());
                List content = requestBody.getContent();
                if (content != null && !content.isEmpty()) {
                    Map<String, List<String>> queries = this.queries((String)content.get(0));
                    HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
                    queries.forEach((key, value) -> map.put((String)key, new ArrayList(value)));
                    return map;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.getMultipartParams();
    }

    private Map<String, List<Object>> getMultipartParams() {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (ServletFileUpload.isMultipartContent(this.request)) {
            int maxMemorySize = 0x40000000;
            File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
            DiskFileItemFactory factory = new DiskFileItemFactory(maxMemorySize, tempDirectory);
            File repository = (File)this.request.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
            factory.setRepository(repository);
            ServletFileUpload upload = new ServletFileUpload(factory);
            int maxRequestSize = 0x40000000;
            upload.setSizeMax(maxRequestSize);
            try {
                Map<String, List<FileItem>> items = upload.parseParameterMap(new ServletRequestContext(this.request));
                this.processFormField(items, map);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private void processFormField(Map<String, List<FileItem>> items, Map<String, List<Object>> map) {
        items.forEach((key, value) -> {
            ArrayList values = new ArrayList();
            value.forEach(fileItem -> {
                if (fileItem.isFormField()) {
                    try {
                        values.add(fileItem.getString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    MultipartFile multipartFile = new MultipartFile();
                    multipartFile.setFileName(fileItem.getName());
                    String type = fileItem.getContentType();
                    MediaType contentType = MediaType.APPLICATION_OCTET_STREAM;
                    if (type != null && !"null".equalsIgnoreCase(type)) {
                        contentType = MediaType.ofWithOctetDefault((String)type);
                    }
                    multipartFile.setContentType(contentType);
                    multipartFile.setContent(fileItem.get());
                    values.add(multipartFile);
                }
            });
            map.put((String)key, values);
        });
    }

    private Map<String, List<String>> queries(String url) {
        return this.queries(url, false);
    }

    private Map<String, List<String>> queries(String url, boolean encode) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (encode) {
            if (url != null) {
                QueryStringDecoder decoder = new QueryStringDecoder(url);
                map.putAll(decoder.parameters());
            }
        } else if (url != null) {
            QueryStringDecoder decoder = new QueryStringDecoder("/?" + url);
            map.putAll(decoder.parameters());
        }
        return map;
    }

    private void setBody() {
        try {
            this.routerRequest.setInputStreamBody((InputStream)this.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setContentType() {
        String respType = this.request.getContentType();
        if (respType != null) {
            this.routerRequest.setContentType(MediaTypeInfo.parse((String)respType));
        } else {
            this.routerRequest.setContentType(MediaType.ANY.info());
        }
    }

    private void setResponseType() {
        String respType = this.request.getHeader("Response-Type");
        MediaTypeInfo mediaType = MediaType.ANY.info();
        if (respType != null) {
            mediaType = MediaTypeInfo.parse((String)respType);
        } else {
            String ext = FileNameUtils.getExtension((String)this.routerRequest.getUrl());
            if (ext != null && !ext.isBlank()) {
                mediaType = MediaType.getTypeByUriExt((String)ext).info();
            }
        }
        this.routerRequest.setResponseType(mediaType);
    }

    private void setRequestAttribute() {
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            this.routerRequest.addAttribute(name, this.request.getAttribute(name));
        }
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bais.read();
            }
        };
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.request.getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.request.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return this.request.getHttpServletMapping();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public PushBuilder newPushBuilder() {
        return this.request.newPushBuilder();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.request.authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this.request.login(username, password);
    }

    public void logout() throws ServletException {
        this.request.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.request.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.request.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return (T)this.request.upgrade(handlerClass);
    }

    public Map<String, String> getTrailerFields() {
        return this.request.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.request.isTrailerFieldsReady();
    }

    public RouterRequest getRouterRequest() {
        return this.routerRequest;
    }
}

