/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet.response;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.common.mini.util.StringUtils;
import com.truthbean.debbie.io.MediaType;
import com.truthbean.debbie.io.MediaTypeInfo;
import com.truthbean.debbie.mvc.response.HttpStatus;
import com.truthbean.debbie.mvc.response.ResponseHandler;
import com.truthbean.debbie.mvc.response.RouterResponse;
import com.truthbean.debbie.mvc.response.view.AbstractTemplateView;
import com.truthbean.debbie.servlet.ServletRouterCookie;
import com.truthbean.debbie.servlet.response.view.JspView;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class ServletResponseHandler
implements ResponseHandler {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletResponseHandler.class);

    public ServletResponseHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void changeResponseWithoutContent(RouterResponse routerResponse) {
        MediaTypeInfo responseType;
        Set cookies;
        Map headers = routerResponse.getHeaders();
        if (!headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)this.response).setHeader(arg_0, arg_1));
        }
        if (!(cookies = routerResponse.getCookies()).isEmpty()) {
            cookies.forEach(cookie -> this.response.addCookie(new ServletRouterCookie((HttpCookie)cookie).getCookie()));
        }
        if ((responseType = routerResponse.getResponseType()) != null) {
            this.response.setContentType(responseType.toString());
        }
        try {
            Map modelAttributes = routerResponse.getModelAttributes();
            if (modelAttributes != null && !modelAttributes.isEmpty()) {
                modelAttributes.forEach((arg_0, arg_1) -> ((HttpServletRequest)this.request).setAttribute(arg_0, arg_1));
            }
        }
        catch (Exception e) {
            LOGGER.error("request.setAttribute error", (Throwable)e);
        }
    }

    public void copyResponseWithoutContent() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Collection headerNames = this.response.getHeaderNames();
        if (headerNames != null && !headerNames.isEmpty()) {
            for (String name : headerNames) {
                String header = this.response.getHeader(name);
                headers.put(name, header);
            }
        }
        int status = this.response.getStatus();
        Supplier trailerFields = this.response.getTrailerFields();
        String characterEncoding = this.response.getCharacterEncoding();
        String contentType = this.response.getContentType();
        Locale locale = this.response.getLocale();
        this.response.reset();
        if (!headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)this.response).addHeader(arg_0, arg_1));
        }
        this.response.setStatus(status);
        if (trailerFields != null) {
            this.response.setTrailerFields(trailerFields);
        }
        this.response.setCharacterEncoding(characterEncoding);
        this.response.setContentType(contentType);
        this.response.setLocale(locale);
    }

    public void handle(RouterResponse routerResponse, MediaTypeInfo defaultResponseType) {
        this.handle(routerResponse, defaultResponseType, true);
    }

    public void handle(RouterResponse routerResponse, MediaTypeInfo defaultResponseType, boolean reset) {
        HttpStatus status = routerResponse.getStatus();
        this.response.setStatus(status.getStatus());
        Object any = routerResponse.getContent();
        MediaTypeInfo responseType = routerResponse.getResponseType();
        if (any == null) {
            LOGGER.debug(() -> "response is null");
        } else if (AbstractTemplateView.isTemplateView((Object)any)) {
            JspView jspView = new JspView();
            if (any instanceof AbstractTemplateView) {
                jspView.from((AbstractTemplateView)any);
            }
            jspView.setHttpServletRequest(this.request);
            jspView.setHttpServletResponse(this.response);
            if (!StringUtils.isBlank((CharSequence)routerResponse.getTemplatePrefix())) {
                jspView.setPrefix(routerResponse.getTemplatePrefix());
            }
            if (!StringUtils.isBlank((CharSequence)routerResponse.getTemplateSuffix())) {
                jspView.setSuffix(routerResponse.getTemplateSuffix());
            }
            jspView.transfer();
        } else {
            if (reset) {
                this.copyResponseWithoutContent();
            }
            this.setResponse(routerResponse, defaultResponseType);
        }
    }

    public void setResponse(RouterResponse routerResponse, MediaTypeInfo defaultResponseType) {
        HttpStatus status = routerResponse.getStatus();
        Object any = routerResponse.getContent();
        MediaTypeInfo responseType = routerResponse.getResponseType();
        if (any instanceof byte[]) {
            this.response.setStatus(routerResponse.getStatus().getStatus());
            if (responseType == null || responseType.isAny()) {
                this.response.setContentType(MediaType.APPLICATION_OCTET_STREAM.getValue());
            }
            this.response.setContentLength(((byte[])any).length);
            try (ServletOutputStream outputStream = this.response.getOutputStream();){
                outputStream.write((byte[])any);
                outputStream.flush();
            }
            catch (IOException e) {
                LOGGER.error(" ", (Throwable)e);
            }
        } else {
            try {
                this.response.setStatus(routerResponse.getStatus().getStatus());
                if (responseType == null) {
                    responseType = defaultResponseType;
                }
                this.response.setContentType(responseType.toString());
                this.response.getWriter().write(String.valueOf(any));
            }
            catch (IOException e) {
                LOGGER.error(" ", (Throwable)e);
            }
        }
    }
}

