/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.debbie.servlet.response.view;

import com.truthbean.Logger;
import com.truthbean.LoggerFactory;
import com.truthbean.debbie.mvc.response.view.AbstractTemplateView;
import com.truthbean.debbie.mvc.response.view.NoViewRender;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class JspView
extends AbstractTemplateView {
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private static final Logger LOGGER = LoggerFactory.getLogger(JspView.class);

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void setModelAndView(AbstractTemplateView modelAndView) {
        this.from(modelAndView);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public AbstractTemplateView getTemplateView() {
        return this;
    }

    private void forward() {
        Map data = this.getAttributes();
        if (!data.isEmpty()) {
            data.forEach((key, value) -> this.httpServletRequest.setAttribute(key, value));
        }
        try {
            this.httpServletRequest.getRequestDispatcher(this.getLocation()).forward((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse);
        }
        catch (ServletException | IOException e) {
            LOGGER.error("servlet forward error", e);
        }
    }

    private void redirect() {
        try {
            this.httpServletResponse.sendRedirect(this.getTemplate());
        }
        catch (IOException e) {
            LOGGER.error("servlet redirect error", (Throwable)e);
        }
    }

    public void transfer() {
        if (super.isRedirect()) {
            this.redirect();
        } else {
            this.forward();
        }
    }

    public NoViewRender render() {
        return new NoViewRender();
    }
}

